@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.PortfolioShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Portfolio Share. Shares the specified portfolio with the specified account or organization node. You can share portfolios to an organization, an organizational unit, or a specific account.
 * If the portfolio share with the specified account or organization node already exists, using this resource to re-create the share will have no effect and will not return an error. You can then use this resource to update the share.
 * > **NOTE:** Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. If a delegated admin is de-registered, they can no longer create portfolio shares.
 * > **NOTE:** AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node.
 * > **NOTE:** You can't share a shared resource, including portfolios that contain a shared product.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.PortfolioShare;
 * import com.pulumi.aws.servicecatalog.PortfolioShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PortfolioShare("example", PortfolioShareArgs.builder()
 *             .principalId("012128675309")
 *             .portfolioId(aws_servicecatalog_portfolio.example().id())
 *             .type("ACCOUNT")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_portfolio_share` using the portfolio share ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/portfolioShare:PortfolioShare example port-12344321:ACCOUNT:123456789012
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property portfolioId Portfolio identifier.
 * @property principalId Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
 * @property sharePrincipals Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
 * @property shareTagOptions Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
 * @property type Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
 * The following arguments are optional:
 * @property waitForAcceptance Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
 */
public data class PortfolioShareArgs(
    public val acceptLanguage: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val sharePrincipals: Output<Boolean>? = null,
    public val shareTagOptions: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val waitForAcceptance: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.PortfolioShareArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.PortfolioShareArgs =
        com.pulumi.aws.servicecatalog.PortfolioShareArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .sharePrincipals(sharePrincipals?.applyValue({ args0 -> args0 }))
            .shareTagOptions(shareTagOptions?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .waitForAcceptance(waitForAcceptance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PortfolioShareArgs].
 */
@PulumiTagMarker
public class PortfolioShareArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var principalId: Output<String>? = null

    private var sharePrincipals: Output<Boolean>? = null

    private var shareTagOptions: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var waitForAcceptance: Output<Boolean>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("fmlfojyrhvevolxe")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("fpcrnmjhtohoybkv")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
     */
    @JvmName("rcsifbvexvwruiqc")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
     */
    @JvmName("bimenoigprpeemnm")
    public suspend fun sharePrincipals(`value`: Output<Boolean>) {
        this.sharePrincipals = value
    }

    /**
     * @param value Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
     */
    @JvmName("atrfyxpjballnrrg")
    public suspend fun shareTagOptions(`value`: Output<Boolean>) {
        this.shareTagOptions = value
    }

    /**
     * @param value Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
     * The following arguments are optional:
     */
    @JvmName("nsotsgulacvglfdk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
     */
    @JvmName("hcugcluwdqyqecnu")
    public suspend fun waitForAcceptance(`value`: Output<Boolean>) {
        this.waitForAcceptance = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("lkpxfcfuumxgocll")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("iljherdnftcdjgui")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Identifier of the principal with whom you will share the portfolio. Valid values AWS account IDs and ARNs of AWS Organizations and organizational units.
     */
    @JvmName("deijgeswdnpoxdgq")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Enables or disables Principal sharing when creating the portfolio share. If this flag is not provided, principal sharing is disabled.
     */
    @JvmName("rpqpweebspcgidne")
    public suspend fun sharePrincipals(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharePrincipals = mapped
    }

    /**
     * @param value Whether to enable sharing of `aws.servicecatalog.TagOption` resources when creating the portfolio share.
     */
    @JvmName("eefiogrxmrocqdyh")
    public suspend fun shareTagOptions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareTagOptions = mapped
    }

    /**
     * @param value Type of portfolio share. Valid values are `ACCOUNT` (an external account), `ORGANIZATION` (a share to every account in an organization), `ORGANIZATIONAL_UNIT`, `ORGANIZATION_MEMBER_ACCOUNT` (a share to an account in an organization).
     * The following arguments are optional:
     */
    @JvmName("kucukmljudyyskga")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Whether to wait (up to the timeout) for the share to be accepted. Organizational shares are automatically accepted.
     */
    @JvmName("ogdxmjgvojuequep")
    public suspend fun waitForAcceptance(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitForAcceptance = mapped
    }

    internal fun build(): PortfolioShareArgs = PortfolioShareArgs(
        acceptLanguage = acceptLanguage,
        portfolioId = portfolioId,
        principalId = principalId,
        sharePrincipals = sharePrincipals,
        shareTagOptions = shareTagOptions,
        type = type,
        waitForAcceptance = waitForAcceptance,
    )
}
