@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PrincipalPortfolioAssociation].
 */
@PulumiTagMarker
public class PrincipalPortfolioAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PrincipalPortfolioAssociationArgs = PrincipalPortfolioAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PrincipalPortfolioAssociationArgsBuilder.() -> Unit) {
        val builder = PrincipalPortfolioAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PrincipalPortfolioAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PrincipalPortfolioAssociation(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Principal Portfolio Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation;
 * import com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrincipalPortfolioAssociation("example", PrincipalPortfolioAssociationArgs.builder()
 *             .portfolioId("port-68656c6c6f")
 *             .principalArn("arn:aws:iam::123456789012:user/Eleanor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_principal_portfolio_association` using `accept_language`, `principal_arn`, `portfolio_id`, and `principal_type` separated by a comma. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation example en,arn:aws:iam::123456789012:user/Eleanor,port-68656c6c6f,IAM
 * ```
 *
 */
public class PrincipalPortfolioAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation,
) : KotlinCustomResource(javaResource, PrincipalPortfolioAssociationMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Portfolio identifier.
     */
    public val portfolioId: Output<String>
        get() = javaResource.portfolioId().applyValue({ args0 -> args0 })

    /**
     * Principal ARN.
     * The following arguments are optional:
     */
    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })

    /**
     * Principal type. Setting this argument empty (e.g., `principal_type = ""`) will result in an error. Valid values are `IAM` and `IAM_PATTERN`. Default is `IAM`.
     */
    public val principalType: Output<String>?
        get() = javaResource.principalType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object PrincipalPortfolioAssociationMapper : ResourceMapper<PrincipalPortfolioAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation::class == javaResource::class

    override fun map(javaResource: Resource): PrincipalPortfolioAssociation =
        PrincipalPortfolioAssociation(
            javaResource as
                com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation,
        )
}

/**
 * @see [PrincipalPortfolioAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PrincipalPortfolioAssociation].
 */
public suspend fun principalPortfolioAssociation(
    name: String,
    block: suspend PrincipalPortfolioAssociationResourceBuilder.() -> Unit,
):
    PrincipalPortfolioAssociation {
    val builder = PrincipalPortfolioAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PrincipalPortfolioAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun principalPortfolioAssociation(name: String): PrincipalPortfolioAssociation {
    val builder = PrincipalPortfolioAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
