@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Principal Portfolio Association.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociation;
 * import com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PrincipalPortfolioAssociation("example", PrincipalPortfolioAssociationArgs.builder()
 *             .portfolioId("port-68656c6c6f")
 *             .principalArn("arn:aws:iam::123456789012:user/Eleanor")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_principal_portfolio_association` using `accept_language`, `principal_arn`, `portfolio_id`, and `principal_type` separated by a comma. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/principalPortfolioAssociation:PrincipalPortfolioAssociation example en,arn:aws:iam::123456789012:user/Eleanor,port-68656c6c6f,IAM
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property portfolioId Portfolio identifier.
 * @property principalArn Principal ARN.
 * The following arguments are optional:
 * @property principalType Principal type. Setting this argument empty (e.g., `principal_type = ""`) will result in an error. Valid values are `IAM` and `IAM_PATTERN`. Default is `IAM`.
 */
public data class PrincipalPortfolioAssociationArgs(
    public val acceptLanguage: Output<String>? = null,
    public val portfolioId: Output<String>? = null,
    public val principalArn: Output<String>? = null,
    public val principalType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs =
        com.pulumi.aws.servicecatalog.PrincipalPortfolioAssociationArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .portfolioId(portfolioId?.applyValue({ args0 -> args0 }))
            .principalArn(principalArn?.applyValue({ args0 -> args0 }))
            .principalType(principalType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrincipalPortfolioAssociationArgs].
 */
@PulumiTagMarker
public class PrincipalPortfolioAssociationArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var portfolioId: Output<String>? = null

    private var principalArn: Output<String>? = null

    private var principalType: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("wjbuxoneusfupucf")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("irhheyguvhjlbjso")
    public suspend fun portfolioId(`value`: Output<String>) {
        this.portfolioId = value
    }

    /**
     * @param value Principal ARN.
     * The following arguments are optional:
     */
    @JvmName("tcnhrfnqdukalvkr")
    public suspend fun principalArn(`value`: Output<String>) {
        this.principalArn = value
    }

    /**
     * @param value Principal type. Setting this argument empty (e.g., `principal_type = ""`) will result in an error. Valid values are `IAM` and `IAM_PATTERN`. Default is `IAM`.
     */
    @JvmName("aiwyooinxefnspku")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("hiipjaceoqfvmdar")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     */
    @JvmName("biavjfnnoygsljsv")
    public suspend fun portfolioId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portfolioId = mapped
    }

    /**
     * @param value Principal ARN.
     * The following arguments are optional:
     */
    @JvmName("cqrmbdjooilkinrx")
    public suspend fun principalArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalArn = mapped
    }

    /**
     * @param value Principal type. Setting this argument empty (e.g., `principal_type = ""`) will result in an error. Valid values are `IAM` and `IAM_PATTERN`. Default is `IAM`.
     */
    @JvmName("kjgnmyqvcpdxcxhm")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    internal fun build(): PrincipalPortfolioAssociationArgs = PrincipalPortfolioAssociationArgs(
        acceptLanguage = acceptLanguage,
        portfolioId = portfolioId,
        principalArn = principalArn,
        principalType = principalType,
    )
}
