@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.kotlin.outputs.ProductProvisioningArtifactParameters
import com.pulumi.aws.servicecatalog.kotlin.outputs.ProductProvisioningArtifactParameters.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Product].
 */
@PulumiTagMarker
public class ProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductArgs = ProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductArgsBuilder.() -> Unit) {
        val builder = ProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Product {
        val builtJavaResource = com.pulumi.aws.servicecatalog.Product(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Product(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Product.
 * > **NOTE:** The user or role that uses this resources must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `template_physical_id` argument.
 * > A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Product;
 * import com.pulumi.aws.servicecatalog.ProductArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Product("example", ProductArgs.builder()
 *             .owner("example-owner")
 *             .provisioningArtifactParameters(ProductProvisioningArtifactParametersArgs.builder()
 *                 .templateUrl("https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/temp1.json")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .type("CLOUD_FORMATION_TEMPLATE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_product` using the product ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/product:Product example prod-dnigbtea24ste
 * ```
 *
 */
public class Product internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.Product,
) : KotlinCustomResource(javaResource, ProductMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the product.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Time when the product was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description of the product.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Distributor (i.e., vendor) of the product.
     */
    public val distributor: Output<String>
        get() = javaResource.distributor().applyValue({ args0 -> args0 })

    /**
     * Whether the product has a default path. If the product does not have a default path, call `ListLaunchPaths` to disambiguate between paths.  Otherwise, `ListLaunchPaths` is not required, and the output of ProductViewSummary can be used directly with `DescribeProvisioningParameters`.
     */
    public val hasDefaultPath: Output<Boolean>
        get() = javaResource.hasDefaultPath().applyValue({ args0 -> args0 })

    /**
     * Name of the product.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Owner of the product.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Configuration block for provisioning artifact (i.e., version) parameters. Detailed below.
     */
    public val provisioningArtifactParameters: Output<ProductProvisioningArtifactParameters>
        get() = javaResource.provisioningArtifactParameters().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Status of the product.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Support information about the product.
     */
    public val supportDescription: Output<String>
        get() = javaResource.supportDescription().applyValue({ args0 -> args0 })

    /**
     * Contact email for product support.
     */
    public val supportEmail: Output<String>
        get() = javaResource.supportEmail().applyValue({ args0 -> args0 })

    /**
     * Contact URL for product support.
     */
    public val supportUrl: Output<String>
        get() = javaResource.supportUrl().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of product. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html#API_CreateProduct_RequestSyntax) for valid list of values.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProductMapper : ResourceMapper<Product> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.Product::class == javaResource::class

    override fun map(javaResource: Resource): Product = Product(
        javaResource as
            com.pulumi.aws.servicecatalog.Product,
    )
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Product].
 */
public suspend fun product(name: String, block: suspend ProductResourceBuilder.() -> Unit):
    Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 */
public fun product(name: String): Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
