@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ProductArgs.builder
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProductProvisioningArtifactParametersArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.ProductProvisioningArtifactParametersArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Product.
 * > **NOTE:** The user or role that uses this resources must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `template_physical_id` argument.
 * > A "provisioning artifact" is also referred to as a "version." A "distributor" is also referred to as a "vendor."
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.Product;
 * import com.pulumi.aws.servicecatalog.ProductArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Product("example", ProductArgs.builder()
 *             .owner("example-owner")
 *             .provisioningArtifactParameters(ProductProvisioningArtifactParametersArgs.builder()
 *                 .templateUrl("https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/temp1.json")
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .type("CLOUD_FORMATION_TEMPLATE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_product` using the product ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/product:Product example prod-dnigbtea24ste
 * ```
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property description Description of the product.
 * @property distributor Distributor (i.e., vendor) of the product.
 * @property name Name of the product.
 * @property owner Owner of the product.
 * @property provisioningArtifactParameters Configuration block for provisioning artifact (i.e., version) parameters. Detailed below.
 * @property supportDescription Support information about the product.
 * @property supportEmail Contact email for product support.
 * @property supportUrl Contact URL for product support.
 * @property tags Tags to apply to the product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of product. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html#API_CreateProduct_RequestSyntax) for valid list of values.
 * The following arguments are optional:
 */
public data class ProductArgs(
    public val acceptLanguage: Output<String>? = null,
    public val description: Output<String>? = null,
    public val distributor: Output<String>? = null,
    public val name: Output<String>? = null,
    public val owner: Output<String>? = null,
    public val provisioningArtifactParameters: Output<ProductProvisioningArtifactParametersArgs>? =
        null,
    public val supportDescription: Output<String>? = null,
    public val supportEmail: Output<String>? = null,
    public val supportUrl: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ProductArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ProductArgs =
        com.pulumi.aws.servicecatalog.ProductArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .distributor(distributor?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .owner(owner?.applyValue({ args0 -> args0 }))
            .provisioningArtifactParameters(
                provisioningArtifactParameters?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .supportDescription(supportDescription?.applyValue({ args0 -> args0 }))
            .supportEmail(supportEmail?.applyValue({ args0 -> args0 }))
            .supportUrl(supportUrl?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductArgs].
 */
@PulumiTagMarker
public class ProductArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var description: Output<String>? = null

    private var distributor: Output<String>? = null

    private var name: Output<String>? = null

    private var owner: Output<String>? = null

    private var provisioningArtifactParameters: Output<ProductProvisioningArtifactParametersArgs>? =
        null

    private var supportDescription: Output<String>? = null

    private var supportEmail: Output<String>? = null

    private var supportUrl: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("xywstoervexpbuil")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Description of the product.
     */
    @JvmName("vvslxlqgxcsvwtgu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Distributor (i.e., vendor) of the product.
     */
    @JvmName("pjcnqktcoqcqifyg")
    public suspend fun distributor(`value`: Output<String>) {
        this.distributor = value
    }

    /**
     * @param value Name of the product.
     */
    @JvmName("ogouhryshslntwom")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Owner of the product.
     */
    @JvmName("nkpnmeydfmfdhwvc")
    public suspend fun owner(`value`: Output<String>) {
        this.owner = value
    }

    /**
     * @param value Configuration block for provisioning artifact (i.e., version) parameters. Detailed below.
     */
    @JvmName("edrafiutfhtmcnfc")
    public suspend
    fun provisioningArtifactParameters(`value`: Output<ProductProvisioningArtifactParametersArgs>) {
        this.provisioningArtifactParameters = value
    }

    /**
     * @param value Support information about the product.
     */
    @JvmName("vdiybglurdffrlup")
    public suspend fun supportDescription(`value`: Output<String>) {
        this.supportDescription = value
    }

    /**
     * @param value Contact email for product support.
     */
    @JvmName("rdeimpgigtbkuqtp")
    public suspend fun supportEmail(`value`: Output<String>) {
        this.supportEmail = value
    }

    /**
     * @param value Contact URL for product support.
     */
    @JvmName("jikbkrfoxehusojg")
    public suspend fun supportUrl(`value`: Output<String>) {
        this.supportUrl = value
    }

    /**
     * @param value Tags to apply to the product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukfnhmqhpebjqapp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of product. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html#API_CreateProduct_RequestSyntax) for valid list of values.
     * The following arguments are optional:
     */
    @JvmName("dtspjpjabxmmjyfx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("bdllouskyfpsbqie")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Description of the product.
     */
    @JvmName("kqiovxnkysoduiml")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Distributor (i.e., vendor) of the product.
     */
    @JvmName("clnllosicgxtbehl")
    public suspend fun distributor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributor = mapped
    }

    /**
     * @param value Name of the product.
     */
    @JvmName("uybxcqgvipitfxen")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Owner of the product.
     */
    @JvmName("aldjciugbffstiia")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owner = mapped
    }

    /**
     * @param value Configuration block for provisioning artifact (i.e., version) parameters. Detailed below.
     */
    @JvmName("vkeqvijctajppjvx")
    public suspend
    fun provisioningArtifactParameters(`value`: ProductProvisioningArtifactParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningArtifactParameters = mapped
    }

    /**
     * @param argument Configuration block for provisioning artifact (i.e., version) parameters. Detailed below.
     */
    @JvmName("kfdtgvcxmwimkxhu")
    public suspend
    fun provisioningArtifactParameters(argument: suspend ProductProvisioningArtifactParametersArgsBuilder.() -> Unit) {
        val toBeMapped = ProductProvisioningArtifactParametersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.provisioningArtifactParameters = mapped
    }

    /**
     * @param value Support information about the product.
     */
    @JvmName("lucflhngdajovenc")
    public suspend fun supportDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportDescription = mapped
    }

    /**
     * @param value Contact email for product support.
     */
    @JvmName("ympblhdnyvsrauuw")
    public suspend fun supportEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportEmail = mapped
    }

    /**
     * @param value Contact URL for product support.
     */
    @JvmName("fbpdkbypebgarxvm")
    public suspend fun supportUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportUrl = mapped
    }

    /**
     * @param value Tags to apply to the product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kqrdginowlxjanni")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the product. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dmfijtunejaelovp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of product. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_CreateProduct.html#API_CreateProduct_RequestSyntax) for valid list of values.
     * The following arguments are optional:
     */
    @JvmName("kvgactuikghtjlnc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProductArgs = ProductArgs(
        acceptLanguage = acceptLanguage,
        description = description,
        distributor = distributor,
        name = name,
        owner = owner,
        provisioningArtifactParameters = provisioningArtifactParameters,
        supportDescription = supportDescription,
        supportEmail = supportEmail,
        supportUrl = supportUrl,
        tags = tags,
        type = type,
    )
}
