@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProvisioningArtifact].
 */
@PulumiTagMarker
public class ProvisioningArtifactResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProvisioningArtifactArgs = ProvisioningArtifactArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProvisioningArtifactArgsBuilder.() -> Unit) {
        val builder = ProvisioningArtifactArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ProvisioningArtifact {
        val builtJavaResource =
            com.pulumi.aws.servicecatalog.ProvisioningArtifact(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProvisioningArtifact(builtJavaResource)
    }
}

/**
 * Manages a Service Catalog Provisioning Artifact for a specified product.
 * > A "provisioning artifact" is also referred to as a "version."
 * > **NOTE:** You cannot create a provisioning artifact for a product that was shared with you.
 * > **NOTE:** The user or role that use this resource must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `template_physical_id` argument.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ProvisioningArtifact;
 * import com.pulumi.aws.servicecatalog.ProvisioningArtifactArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProvisioningArtifact("example", ProvisioningArtifactArgs.builder()
 *             .productId(aws_servicecatalog_product.example().id())
 *             .type("CLOUD_FORMATION_TEMPLATE")
 *             .templateUrl(String.format("https://%s/%s", aws_s3_bucket.example().bucket_regional_domain_name(),aws_s3_object.example().key()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_provisioning_artifact` using the provisioning artifact ID and product ID separated by a colon. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/provisioningArtifact:ProvisioningArtifact example pa-ij2b6lusy6dec:prod-el3an0rma3
 * ```
 *
 */
public class ProvisioningArtifact internal constructor(
    override val javaResource: com.pulumi.aws.servicecatalog.ProvisioningArtifact,
) : KotlinCustomResource(javaResource, ProvisioningArtifactMapper) {
    /**
     * Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). The default value is `en`.
     */
    public val acceptLanguage: Output<String>?
        get() = javaResource.acceptLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Default is `true`.
     */
    public val active: Output<Boolean>?
        get() = javaResource.active().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Time when the provisioning artifact was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     */
    public val disableTemplateValidation: Output<Boolean>?
        get() = javaResource.disableTemplateValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. Valid values are `DEFAULT` and `DEPRECATED`. The default is `DEFAULT`. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version.
     */
    public val guidance: Output<String>?
        get() = javaResource.guidance().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Identifier of the product.
     */
    public val productId: Output<String>
        get() = javaResource.productId().applyValue({ args0 -> args0 })

    /**
     * Provisioning artifact identifier.
     */
    public val provisioningArtifactId: Output<String>
        get() = javaResource.provisioningArtifactId().applyValue({ args0 -> args0 })

    /**
     * Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     */
    public val templatePhysicalId: Output<String>?
        get() = javaResource.templatePhysicalId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Template source as URL of the CloudFormation template in Amazon S3.
     * The following arguments are optional:
     */
    public val templateUrl: Output<String>?
        get() = javaResource.templateUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ProvisioningArtifactMapper : ResourceMapper<ProvisioningArtifact> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicecatalog.ProvisioningArtifact::class == javaResource::class

    override fun map(javaResource: Resource): ProvisioningArtifact = ProvisioningArtifact(
        javaResource
            as com.pulumi.aws.servicecatalog.ProvisioningArtifact,
    )
}

/**
 * @see [ProvisioningArtifact].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProvisioningArtifact].
 */
public suspend fun provisioningArtifact(
    name: String,
    block: suspend ProvisioningArtifactResourceBuilder.() -> Unit,
): ProvisioningArtifact {
    val builder = ProvisioningArtifactResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProvisioningArtifact].
 * @param name The _unique_ name of the resulting resource.
 */
public fun provisioningArtifact(name: String): ProvisioningArtifact {
    val builder = ProvisioningArtifactResourceBuilder()
    builder.name(name)
    return builder.build()
}
