@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.ServiceActionArgs.builder
import com.pulumi.aws.servicecatalog.kotlin.inputs.ServiceActionDefinitionArgs
import com.pulumi.aws.servicecatalog.kotlin.inputs.ServiceActionDefinitionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog self-service action.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.ServiceAction;
 * import com.pulumi.aws.servicecatalog.ServiceActionArgs;
 * import com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceAction("example", ServiceActionArgs.builder()
 *             .definition(ServiceActionDefinitionArgs.builder()
 *                 .name("AWS-RestartEC2Instance")
 *                 .build())
 *             .description("Motor generator unit")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_service_action` using the service action ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/serviceAction:ServiceAction example act-f1w12eperfslh
 * ```
 * @property acceptLanguage Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
 * @property definition Self-service action definition configuration block. Detailed below.
 * @property description Self-service action description.
 * @property name Self-service action name.
 * The following arguments are optional:
 */
public data class ServiceActionArgs(
    public val acceptLanguage: Output<String>? = null,
    public val definition: Output<ServiceActionDefinitionArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.ServiceActionArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.ServiceActionArgs =
        com.pulumi.aws.servicecatalog.ServiceActionArgs.builder()
            .acceptLanguage(acceptLanguage?.applyValue({ args0 -> args0 }))
            .definition(definition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceActionArgs].
 */
@PulumiTagMarker
public class ServiceActionArgsBuilder internal constructor() {
    private var acceptLanguage: Output<String>? = null

    private var definition: Output<ServiceActionDefinitionArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
     */
    @JvmName("guckpaxyxcmlncwb")
    public suspend fun acceptLanguage(`value`: Output<String>) {
        this.acceptLanguage = value
    }

    /**
     * @param value Self-service action definition configuration block. Detailed below.
     */
    @JvmName("kefbmghrftursegr")
    public suspend fun definition(`value`: Output<ServiceActionDefinitionArgs>) {
        this.definition = value
    }

    /**
     * @param value Self-service action description.
     */
    @JvmName("fvkwqhjcbotpjhbh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Self-service action name.
     * The following arguments are optional:
     */
    @JvmName("rcmmxjebbefjjaqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Language code. Valid values are `en` (English), `jp` (Japanese), and `zh` (Chinese). Default is `en`.
     */
    @JvmName("iotveasuegohcmmb")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Self-service action definition configuration block. Detailed below.
     */
    @JvmName("ouhbecvfutkecshw")
    public suspend fun definition(`value`: ServiceActionDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.definition = mapped
    }

    /**
     * @param argument Self-service action definition configuration block. Detailed below.
     */
    @JvmName("bwyjmrxiwupmfdwa")
    public suspend fun definition(argument: suspend ServiceActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceActionDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.definition = mapped
    }

    /**
     * @param value Self-service action description.
     */
    @JvmName("hpudmtcctrqhlefg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Self-service action name.
     * The following arguments are optional:
     */
    @JvmName("xsxryaqccfdolqjd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ServiceActionArgs = ServiceActionArgs(
        acceptLanguage = acceptLanguage,
        definition = definition,
        description = description,
        name = name,
    )
}
