@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin

import com.pulumi.aws.servicecatalog.TagOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a Service Catalog Tag Option.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicecatalog.TagOption;
 * import com.pulumi.aws.servicecatalog.TagOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TagOption("example", TagOptionArgs.builder()
 *             .key("nyckel")
 *             .value("värde")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_servicecatalog_tag_option` using the tag option ID. For example:
 * ```sh
 *  $ pulumi import aws:servicecatalog/tagOption:TagOption example tag-pjtvagohlyo3m
 * ```
 * @property active Whether tag option is active. Default is `true`.
 * @property key Tag option key.
 * @property value Tag option value.
 * The following arguments are optional:
 */
public data class TagOptionArgs(
    public val active: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.TagOptionArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.TagOptionArgs =
        com.pulumi.aws.servicecatalog.TagOptionArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagOptionArgs].
 */
@PulumiTagMarker
public class TagOptionArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Whether tag option is active. Default is `true`.
     */
    @JvmName("rvsmxfgdeadvkuoj")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value Tag option key.
     */
    @JvmName("jdrdptokanuejbbf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Tag option value.
     * The following arguments are optional:
     */
    @JvmName("mmtaqgedfpagqyjj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Whether tag option is active. Default is `true`.
     */
    @JvmName("wdatgxnrelyratqw")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value Tag option key.
     */
    @JvmName("udrdntigccalwmeh")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Tag option value.
     * The following arguments are optional:
     */
    @JvmName("cnpphbwhkvtsofss")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): TagOptionArgs = TagOptionArgs(
        active = active,
        key = key,
        `value` = `value`,
    )
}
