@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.GetConstraintPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConstraint.
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property description Description of the constraint.
 * @property id Constraint identifier.
 * The following arguments are optional:
 */
public data class GetConstraintPlainArgs(
    public val acceptLanguage: String? = null,
    public val description: String? = null,
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.GetConstraintPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.GetConstraintPlainArgs =
        com.pulumi.aws.servicecatalog.inputs.GetConstraintPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .description(description?.let({ args0 -> args0 }))
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConstraintPlainArgs].
 */
@PulumiTagMarker
public class GetConstraintPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var description: String? = null

    private var id: String? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("xlchmquqfdbbqjvc")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Description of the constraint.
     */
    @JvmName("ukpbuvyivaicqcjr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value Constraint identifier.
     * The following arguments are optional:
     */
    @JvmName("xpjpwqtoihtxsuld")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetConstraintPlainArgs = GetConstraintPlainArgs(
        acceptLanguage = acceptLanguage,
        description = description,
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
