@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.GetPortfolioConstraintsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPortfolioConstraints.
 * @property acceptLanguage Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
 * @property portfolioId Portfolio identifier.
 * The following arguments are optional:
 * @property productId Product identifier.
 */
public data class GetPortfolioConstraintsPlainArgs(
    public val acceptLanguage: String? = null,
    public val portfolioId: String,
    public val productId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.GetPortfolioConstraintsPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.GetPortfolioConstraintsPlainArgs =
        com.pulumi.aws.servicecatalog.inputs.GetPortfolioConstraintsPlainArgs.builder()
            .acceptLanguage(acceptLanguage?.let({ args0 -> args0 }))
            .portfolioId(portfolioId.let({ args0 -> args0 }))
            .productId(productId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPortfolioConstraintsPlainArgs].
 */
@PulumiTagMarker
public class GetPortfolioConstraintsPlainArgsBuilder internal constructor() {
    private var acceptLanguage: String? = null

    private var portfolioId: String? = null

    private var productId: String? = null

    /**
     * @param value Language code. Valid values: `en` (English), `jp` (Japanese), `zh` (Chinese). Default value is `en`.
     */
    @JvmName("xyaklpkhceggsnqa")
    public suspend fun acceptLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.acceptLanguage = mapped
    }

    /**
     * @param value Portfolio identifier.
     * The following arguments are optional:
     */
    @JvmName("yqnchyypidvuuxyg")
    public suspend fun portfolioId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.portfolioId = mapped
    }

    /**
     * @param value Product identifier.
     */
    @JvmName("yhxamgvrpunfwnkf")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productId = mapped
    }

    internal fun build(): GetPortfolioConstraintsPlainArgs = GetPortfolioConstraintsPlainArgs(
        acceptLanguage = acceptLanguage,
        portfolioId = portfolioId ?: throw PulumiNullFieldException("portfolioId"),
        productId = productId,
    )
}
