@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
 * @property disableTemplateValidation Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
 * @property name Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
 * @property templatePhysicalId Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
 * @property templateUrl Template source as URL of the CloudFormation template in Amazon S3.
 * @property type Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
 */
public data class ProductProvisioningArtifactParametersArgs(
    public val description: Output<String>? = null,
    public val disableTemplateValidation: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val templatePhysicalId: Output<String>? = null,
    public val templateUrl: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs> {
    override fun toJava():
        com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs =
        com.pulumi.aws.servicecatalog.inputs.ProductProvisioningArtifactParametersArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .disableTemplateValidation(disableTemplateValidation?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .templatePhysicalId(templatePhysicalId?.applyValue({ args0 -> args0 }))
            .templateUrl(templateUrl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductProvisioningArtifactParametersArgs].
 */
@PulumiTagMarker
public class ProductProvisioningArtifactParametersArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var disableTemplateValidation: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var templatePhysicalId: Output<String>? = null

    private var templateUrl: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     */
    @JvmName("wrueiaxjricuftqj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     */
    @JvmName("ekftdhygptgibxyn")
    public suspend fun disableTemplateValidation(`value`: Output<Boolean>) {
        this.disableTemplateValidation = value
    }

    /**
     * @param value Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     */
    @JvmName("ggbodnlajrvbcbbc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     */
    @JvmName("sjuhrdugvoiydabu")
    public suspend fun templatePhysicalId(`value`: Output<String>) {
        this.templatePhysicalId = value
    }

    /**
     * @param value Template source as URL of the CloudFormation template in Amazon S3.
     */
    @JvmName("lxnrsdjdrcdcetyi")
    public suspend fun templateUrl(`value`: Output<String>) {
        this.templateUrl = value
    }

    /**
     * @param value Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     */
    @JvmName("kbhhyvfbltejptnv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
     */
    @JvmName("mbaxtvpvfkowasnr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
     */
    @JvmName("ckdplajdydpefknw")
    public suspend fun disableTemplateValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableTemplateValidation = mapped
    }

    /**
     * @param value Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
     */
    @JvmName("ucowtuodkopkkdst")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
     */
    @JvmName("jksuhlpprphjqscb")
    public suspend fun templatePhysicalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templatePhysicalId = mapped
    }

    /**
     * @param value Template source as URL of the CloudFormation template in Amazon S3.
     */
    @JvmName("hklcppxhxspneufu")
    public suspend fun templateUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateUrl = mapped
    }

    /**
     * @param value Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
     */
    @JvmName("hnyqowgbjhqswpfh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProductProvisioningArtifactParametersArgs =
        ProductProvisioningArtifactParametersArgs(
            description = description,
            disableTemplateValidation = disableTemplateValidation,
            name = name,
            templatePhysicalId = templatePhysicalId,
            templateUrl = templateUrl,
            type = type,
        )
}
