@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.inputs

import com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assumeRole ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
 * @property name Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
 * @property parameters List of parameters in JSON format. For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
 * @property type Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
 * @property version SSM document version. For example, `1`.
 */
public data class ServiceActionDefinitionArgs(
    public val assumeRole: Output<String>? = null,
    public val name: Output<String>,
    public val parameters: Output<String>? = null,
    public val type: Output<String>? = null,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs =
        com.pulumi.aws.servicecatalog.inputs.ServiceActionDefinitionArgs.builder()
            .assumeRole(assumeRole?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceActionDefinitionArgs].
 */
@PulumiTagMarker
public class ServiceActionDefinitionArgsBuilder internal constructor() {
    private var assumeRole: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<String>? = null

    private var type: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
     */
    @JvmName("cohhvoybnsupqsdk")
    public suspend fun assumeRole(`value`: Output<String>) {
        this.assumeRole = value
    }

    /**
     * @param value Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
     */
    @JvmName("rkemgumfnkdjqvlf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of parameters in JSON format. For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
     */
    @JvmName("ygneprrvdartgwif")
    public suspend fun parameters(`value`: Output<String>) {
        this.parameters = value
    }

    /**
     * @param value Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
     */
    @JvmName("oyiidbansggpuaue")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value SSM document version. For example, `1`.
     */
    @JvmName("mkhyjdtnohupysgu")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value ARN of the role that performs the self-service actions on your behalf. For example, `arn:aws:iam::12345678910:role/ActionRole`. To reuse the provisioned product launch role, set to `LAUNCH_ROLE`.
     */
    @JvmName("xgdqjeaycyjfxshi")
    public suspend fun assumeRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assumeRole = mapped
    }

    /**
     * @param value Name of the SSM document. For example, `AWS-RestartEC2Instance`. If you are using a shared SSM document, you must provide the ARN instead of the name.
     */
    @JvmName("rdgcwuanoaxlroab")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of parameters in JSON format. For example: `[{\"Name\":\"InstanceId\",\"Type\":\"TARGET\"}]` or `[{\"Name\":\"InstanceId\",\"Type\":\"TEXT_VALUE\"}]`.
     */
    @JvmName("diukyohhrxrsnkkf")
    public suspend fun parameters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Service action definition type. Valid value is `SSM_AUTOMATION`. Default is `SSM_AUTOMATION`.
     */
    @JvmName("mjxaqjfxclxmlndc")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value SSM document version. For example, `1`.
     */
    @JvmName("qnoprfkbovjdyrwa")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServiceActionDefinitionArgs = ServiceActionDefinitionArgs(
        assumeRole = assumeRole,
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        type = type,
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
