@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getConstraint.
 * @property acceptLanguage
 * @property description Description of the constraint.
 * @property id
 * @property owner Owner of the constraint.
 * @property parameters Constraint parameters in JSON format.
 * @property portfolioId Portfolio identifier.
 * @property productId Product identifier.
 * @property status Constraint status.
 * @property type Type of constraint. Valid values are `LAUNCH`, `NOTIFICATION`, `RESOURCE_UPDATE`, `STACKSET`, and `TEMPLATE`.
 */
public data class GetConstraintResult(
    public val acceptLanguage: String? = null,
    public val description: String,
    public val id: String,
    public val owner: String,
    public val parameters: String,
    public val portfolioId: String,
    public val productId: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetConstraintResult):
            GetConstraintResult = GetConstraintResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            description = javaType.description(),
            id = javaType.id(),
            owner = javaType.owner(),
            parameters = javaType.parameters(),
            portfolioId = javaType.portfolioId(),
            productId = javaType.productId(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
