@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLaunchPaths.
 * @property acceptLanguage
 * @property id The provider-assigned unique ID for this managed resource.
 * @property productId
 * @property summaries Block with information about the launch path. See details below.
 */
public data class GetLaunchPathsResult(
    public val acceptLanguage: String? = null,
    public val id: String,
    public val productId: String,
    public val summaries: List<GetLaunchPathsSummary>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetLaunchPathsResult):
            GetLaunchPathsResult = GetLaunchPathsResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            productId = javaType.productId(),
            summaries = javaType.summaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicecatalog.kotlin.outputs.GetLaunchPathsSummary.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
