@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property constraintSummaries Block for constraints on the portfolio-product relationship. See details below.
 * @property name Name of the portfolio to which the path was assigned.
 * @property pathId Identifier of the product path.
 * @property tags Tags associated with this product path.
 */
public data class GetLaunchPathsSummary(
    public val constraintSummaries: List<GetLaunchPathsSummaryConstraintSummary>,
    public val name: String,
    public val pathId: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetLaunchPathsSummary):
            GetLaunchPathsSummary = GetLaunchPathsSummary(
            constraintSummaries = javaType.constraintSummaries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicecatalog.kotlin.outputs.GetLaunchPathsSummaryConstraintSummary.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            pathId = javaType.pathId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
