@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPortfolioConstraints.
 * @property acceptLanguage
 * @property details List of information about the constraints. See details below.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property portfolioId Identifier of the portfolio the product resides in. The constraint applies only to the instance of the product that lives within this portfolio.
 * @property productId Identifier of the product the constraint applies to. A constraint applies to a specific instance of a product within a certain portfolio.
 */
public data class GetPortfolioConstraintsResult(
    public val acceptLanguage: String? = null,
    public val details: List<GetPortfolioConstraintsDetail>,
    public val id: String,
    public val portfolioId: String,
    public val productId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetPortfolioConstraintsResult):
            GetPortfolioConstraintsResult = GetPortfolioConstraintsResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicecatalog.kotlin.outputs.GetPortfolioConstraintsDetail.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            portfolioId = javaType.portfolioId(),
            productId = javaType.productId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
