@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProvisioningArtifacts.
 * @property acceptLanguage
 * @property id The provider-assigned unique ID for this managed resource.
 * @property productId
 * @property provisioningArtifactDetails List with information about the provisioning artifacts. See details below.
 */
public data class GetProvisioningArtifactsResult(
    public val acceptLanguage: String? = null,
    public val id: String,
    public val productId: String,
    public val provisioningArtifactDetails: List<GetProvisioningArtifactsProvisioningArtifactDetail>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.GetProvisioningArtifactsResult):
            GetProvisioningArtifactsResult = GetProvisioningArtifactsResult(
            acceptLanguage = javaType.acceptLanguage().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            productId = javaType.productId(),
            provisioningArtifactDetails = javaType.provisioningArtifactDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicecatalog.kotlin.outputs.GetProvisioningArtifactsProvisioningArtifactDetail.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
