@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicecatalog.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the provisioning artifact (i.e., version), including how it differs from the previous provisioning artifact.
 * @property disableTemplateValidation Whether AWS Service Catalog stops validating the specified provisioning artifact template even if it is invalid.
 * @property name Name of the provisioning artifact (for example, `v1`, `v2beta`). No spaces are allowed.
 * @property templatePhysicalId Template source as the physical ID of the resource that contains the template. Currently only supports CloudFormation stack ARN. Specify the physical ID as `arn:[partition]:cloudformation:[region]:[account ID]:stack/[stack name]/[resource ID]`.
 * @property templateUrl Template source as URL of the CloudFormation template in Amazon S3.
 * @property type Type of provisioning artifact. See [AWS Docs](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ProvisioningArtifactProperties.html) for valid list of values.
 */
public data class ProductProvisioningArtifactParameters(
    public val description: String? = null,
    public val disableTemplateValidation: Boolean? = null,
    public val name: String? = null,
    public val templatePhysicalId: String? = null,
    public val templateUrl: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicecatalog.outputs.ProductProvisioningArtifactParameters):
            ProductProvisioningArtifactParameters = ProductProvisioningArtifactParameters(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            disableTemplateValidation = javaType.disableTemplateValidation().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            templatePhysicalId = javaType.templatePhysicalId().map({ args0 -> args0 }).orElse(null),
            templateUrl = javaType.templateUrl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
