@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.HttpNamespaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicediscovery.HttpNamespace;
 * import com.pulumi.aws.servicediscovery.HttpNamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new HttpNamespace("example", HttpNamespaceArgs.builder()
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Service Discovery HTTP Namespace using the namespace ID. For example:
 * ```sh
 *  $ pulumi import aws:servicediscovery/httpNamespace:HttpNamespace example ns-1234567890
 * ```
 * @property description The description that you specify for the namespace when you create it.
 * @property name The name of the http namespace.
 * @property tags A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class HttpNamespaceArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.HttpNamespaceArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.HttpNamespaceArgs =
        com.pulumi.aws.servicediscovery.HttpNamespaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [HttpNamespaceArgs].
 */
@PulumiTagMarker
public class HttpNamespaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description that you specify for the namespace when you create it.
     */
    @JvmName("ynsojautjrrncoje")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the http namespace.
     */
    @JvmName("xsrcabgngofeaxmx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sytxmunltrvccvaq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description that you specify for the namespace when you create it.
     */
    @JvmName("tovnlbdopwcprvro")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the http namespace.
     */
    @JvmName("brqegkasxyievjkt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vsatmhcoxwdcaprj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the namespace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vhregfyirnvybeia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): HttpNamespaceArgs = HttpNamespaceArgs(
        description = description,
        name = name,
        tags = tags,
    )
}
