@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Service Discovery Instance resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs;
 * import com.pulumi.aws.servicediscovery.Instance;
 * import com.pulumi.aws.servicediscovery.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var examplePrivateDnsNamespace = new PrivateDnsNamespace("examplePrivateDnsNamespace", PrivateDnsNamespaceArgs.builder()
 *             .description("example")
 *             .vpc(exampleVpc.id())
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(examplePrivateDnsNamespace.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .routingPolicy("MULTIVALUE")
 *                 .build())
 *             .healthCheckCustomConfig(ServiceHealthCheckCustomConfigArgs.builder()
 *                 .failureThreshold(1)
 *                 .build())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .instanceId("example-instance-id")
 *             .serviceId(exampleService.id())
 *             .attributes(Map.ofEntries(
 *                 Map.entry("AWS_INSTANCE_IPV4", "172.18.0.1"),
 *                 Map.entry("custom_attribute", "custom")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Service Discovery Instance using the service ID and instance ID. For example:
 * ```sh
 *  $ pulumi import aws:servicediscovery/instance:Instance example 0123456789/i-0123
 * ```
 * @property attributes A map contains the attributes of the instance. Check the [doc](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#API_RegisterInstance_RequestSyntax) for the supported attributes and syntax.
 * @property instanceId The ID of the service instance.
 * @property serviceId The ID of the service that you want to use to create the instance.
 */
public data class InstanceArgs(
    public val attributes: Output<Map<String, String>>? = null,
    public val instanceId: Output<String>? = null,
    public val serviceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.InstanceArgs =
        com.pulumi.aws.servicediscovery.InstanceArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .serviceId(serviceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var attributes: Output<Map<String, String>>? = null

    private var instanceId: Output<String>? = null

    private var serviceId: Output<String>? = null

    /**
     * @param value A map contains the attributes of the instance. Check the [doc](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#API_RegisterInstance_RequestSyntax) for the supported attributes and syntax.
     */
    @JvmName("kvrdsplvbdjsghir")
    public suspend fun attributes(`value`: Output<Map<String, String>>) {
        this.attributes = value
    }

    /**
     * @param value The ID of the service instance.
     */
    @JvmName("jgyakmsripotblis")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the service that you want to use to create the instance.
     */
    @JvmName("smiebekysycejghg")
    public suspend fun serviceId(`value`: Output<String>) {
        this.serviceId = value
    }

    /**
     * @param value A map contains the attributes of the instance. Check the [doc](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#API_RegisterInstance_RequestSyntax) for the supported attributes and syntax.
     */
    @JvmName("rbfsyfjbuqjjdxyf")
    public suspend fun attributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values A map contains the attributes of the instance. Check the [doc](https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#API_RegisterInstance_RequestSyntax) for the supported attributes and syntax.
     */
    @JvmName("ylybfrsmbvdmdxua")
    public fun attributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The ID of the service instance.
     */
    @JvmName("xnenprksfffdhric")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the service that you want to use to create the instance.
     */
    @JvmName("jxeixmvqsscummcv")
    public suspend fun serviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        attributes = attributes,
        instanceId = instanceId,
        serviceId = serviceId,
    )
}
