@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.ServiceArgs.builder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceDnsConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceDnsConfigArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckConfigArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckCustomConfigArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.ServiceHealthCheckCustomConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Service Discovery Service resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespace;
 * import com.pulumi.aws.servicediscovery.PrivateDnsNamespaceArgs;
 * import com.pulumi.aws.servicediscovery.Service;
 * import com.pulumi.aws.servicediscovery.ServiceArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceDnsConfigArgs;
 * import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsSupport(true)
 *             .enableDnsHostnames(true)
 *             .build());
 *         var examplePrivateDnsNamespace = new PrivateDnsNamespace("examplePrivateDnsNamespace", PrivateDnsNamespaceArgs.builder()
 *             .description("example")
 *             .vpc(exampleVpc.id())
 *             .build());
 *         var exampleService = new Service("exampleService", ServiceArgs.builder()
 *             .dnsConfig(ServiceDnsConfigArgs.builder()
 *                 .namespaceId(examplePrivateDnsNamespace.id())
 *                 .dnsRecords(ServiceDnsConfigDnsRecordArgs.builder()
 *                     .ttl(10)
 *                     .type("A")
 *                     .build())
 *                 .routingPolicy("MULTIVALUE")
 *                 .build())
 *             .healthCheckCustomConfig(ServiceHealthCheckCustomConfigArgs.builder()
 *                 .failureThreshold(1)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Service Discovery Service using the service ID. For example:
 * ```sh
 *  $ pulumi import aws:servicediscovery/service:Service example 0123456789
 * ```
 * @property description The description of the service.
 * @property dnsConfig A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance.
 * @property forceDestroy A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable.
 * @property healthCheckConfig A complex type that contains settings for an optional health check. Only for Public DNS namespaces.
 * @property healthCheckCustomConfig A complex type that contains settings for ECS managed health checks.
 * @property name The name of the service.
 * @property namespaceId The ID of the namespace that you want to use to create the service.
 * @property tags A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
 */
public data class ServiceArgs(
    public val description: Output<String>? = null,
    public val dnsConfig: Output<ServiceDnsConfigArgs>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val healthCheckConfig: Output<ServiceHealthCheckConfigArgs>? = null,
    public val healthCheckCustomConfig: Output<ServiceHealthCheckCustomConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val namespaceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.ServiceArgs =
        com.pulumi.aws.servicediscovery.ServiceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dnsConfig(dnsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .healthCheckCustomConfig(
                healthCheckCustomConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceId(namespaceId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dnsConfig: Output<ServiceDnsConfigArgs>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var healthCheckConfig: Output<ServiceHealthCheckConfigArgs>? = null

    private var healthCheckCustomConfig: Output<ServiceHealthCheckCustomConfigArgs>? = null

    private var name: Output<String>? = null

    private var namespaceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The description of the service.
     */
    @JvmName("xdvduborjdxlgreh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance.
     */
    @JvmName("bjjvlxocbjkewfql")
    public suspend fun dnsConfig(`value`: Output<ServiceDnsConfigArgs>) {
        this.dnsConfig = value
    }

    /**
     * @param value A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable.
     */
    @JvmName("hwuacnrsmcwblxdr")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value A complex type that contains settings for an optional health check. Only for Public DNS namespaces.
     */
    @JvmName("ssqjmmokbxbrbrxo")
    public suspend fun healthCheckConfig(`value`: Output<ServiceHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value A complex type that contains settings for ECS managed health checks.
     */
    @JvmName("lyaaicmtdygthhtt")
    public suspend fun healthCheckCustomConfig(`value`: Output<ServiceHealthCheckCustomConfigArgs>) {
        this.healthCheckCustomConfig = value
    }

    /**
     * @param value The name of the service.
     */
    @JvmName("ncfjobgfcwthmrlp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID of the namespace that you want to use to create the service.
     */
    @JvmName("qxfrpfmdwanhpgdp")
    public suspend fun namespaceId(`value`: Output<String>) {
        this.namespaceId = value
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ocgfmoojtsyswpou")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    @JvmName("waiqbiqwtycyctek")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The description of the service.
     */
    @JvmName("ryrhmusyfjelsvmc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance.
     */
    @JvmName("fvuwabkbitwrvxtf")
    public suspend fun dnsConfig(`value`: ServiceDnsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsConfig = mapped
    }

    /**
     * @param argument A complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance.
     */
    @JvmName("iamxpoflirotpqax")
    public suspend fun dnsConfig(argument: suspend ServiceDnsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceDnsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsConfig = mapped
    }

    /**
     * @param value A boolean that indicates all instances should be deleted from the service so that the service can be destroyed without error. These instances are not recoverable.
     */
    @JvmName("twacaexckapuqhbn")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value A complex type that contains settings for an optional health check. Only for Public DNS namespaces.
     */
    @JvmName("lkpgedtjpqhltvqc")
    public suspend fun healthCheckConfig(`value`: ServiceHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument A complex type that contains settings for an optional health check. Only for Public DNS namespaces.
     */
    @JvmName("pweejcjucdieqhdy")
    public suspend
    fun healthCheckConfig(argument: suspend ServiceHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceHealthCheckConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value A complex type that contains settings for ECS managed health checks.
     */
    @JvmName("lgdcqoruvybhiwti")
    public suspend fun healthCheckCustomConfig(`value`: ServiceHealthCheckCustomConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckCustomConfig = mapped
    }

    /**
     * @param argument A complex type that contains settings for ECS managed health checks.
     */
    @JvmName("lhrheajxbkddnhhl")
    public suspend
    fun healthCheckCustomConfig(argument: suspend ServiceHealthCheckCustomConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceHealthCheckCustomConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckCustomConfig = mapped
    }

    /**
     * @param value The name of the service.
     */
    @JvmName("klxxxjamxdlpivfs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ID of the namespace that you want to use to create the service.
     */
    @JvmName("ujsbktxpwtxqsotq")
    public suspend fun namespaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceId = mapped
    }

    /**
     * @param value A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xvdflyxuualiriyu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jbiuvfybfxsphxga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If present, specifies that the service instances are only discoverable using the `DiscoverInstances` API operation. No DNS records is registered for the service instances. The only valid value is `HTTP`.
     */
    @JvmName("qmvyoaymiicnycas")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        description = description,
        dnsConfig = dnsConfig,
        forceDestroy = forceDestroy,
        healthCheckConfig = healthCheckConfig,
        healthCheckCustomConfig = healthCheckCustomConfig,
        name = name,
        namespaceId = namespaceId,
        tags = tags,
        type = type,
    )
}
