@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin

import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions.getDnsNamespacePlain
import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions.getHttpNamespacePlain
import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions.getServicePlain
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetDnsNamespacePlainArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetDnsNamespacePlainArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetHttpNamespacePlainArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetHttpNamespacePlainArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.servicediscovery.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetDnsNamespaceResult
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetHttpNamespaceResult
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetDnsNamespaceResult.Companion.toKotlin as getDnsNamespaceResultToKotlin
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetHttpNamespaceResult.Companion.toKotlin as getHttpNamespaceResultToKotlin
import com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object ServicediscoveryFunctions {
    /**
     * Retrieves information about a Service Discovery private or public DNS namespace.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions;
     * import com.pulumi.aws.servicediscovery.inputs.GetDnsNamespaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ServicediscoveryFunctions.getDnsNamespace(GetDnsNamespaceArgs.builder()
     *             .name("example.service.local")
     *             .type("DNS_PRIVATE")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDnsNamespace.
     * @return A collection of values returned by getDnsNamespace.
     */
    public suspend fun getDnsNamespace(argument: GetDnsNamespacePlainArgs): GetDnsNamespaceResult =
        getDnsNamespaceResultToKotlin(getDnsNamespacePlain(argument.toJava()).await())

    /**
     * @see [getDnsNamespace].
     * @param name Name of the namespace.
     * @param tags Map of tags for the resource.
     * @param type Type of the namespace. Allowed values are `DNS_PUBLIC` or `DNS_PRIVATE`.
     * @return A collection of values returned by getDnsNamespace.
     */
    public suspend fun getDnsNamespace(
        name: String,
        tags: Map<String, String>? = null,
        type: String,
    ): GetDnsNamespaceResult {
        val argument = GetDnsNamespacePlainArgs(
            name = name,
            tags = tags,
            type = type,
        )
        return getDnsNamespaceResultToKotlin(getDnsNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getDnsNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicediscovery&#46;kotlin&#46;inputs&#46;GetDnsNamespacePlainArgs].
     * @return A collection of values returned by getDnsNamespace.
     */
    public suspend fun getDnsNamespace(argument: suspend GetDnsNamespacePlainArgsBuilder.() -> Unit):
        GetDnsNamespaceResult {
        val builder = GetDnsNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDnsNamespaceResultToKotlin(getDnsNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions;
     * import com.pulumi.aws.servicediscovery.inputs.GetHttpNamespaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicediscoveryFunctions.getHttpNamespace(GetHttpNamespaceArgs.builder()
     *             .name("development")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getHttpNamespace.
     * @return A collection of values returned by getHttpNamespace.
     */
    public suspend fun getHttpNamespace(argument: GetHttpNamespacePlainArgs): GetHttpNamespaceResult =
        getHttpNamespaceResultToKotlin(getHttpNamespacePlain(argument.toJava()).await())

    /**
     * @see [getHttpNamespace].
     * @param name Name of the http namespace.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getHttpNamespace.
     */
    public suspend fun getHttpNamespace(name: String, tags: Map<String, String>? = null):
        GetHttpNamespaceResult {
        val argument = GetHttpNamespacePlainArgs(
            name = name,
            tags = tags,
        )
        return getHttpNamespaceResultToKotlin(getHttpNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getHttpNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicediscovery&#46;kotlin&#46;inputs&#46;GetHttpNamespacePlainArgs].
     * @return A collection of values returned by getHttpNamespace.
     */
    public suspend
    fun getHttpNamespace(argument: suspend GetHttpNamespacePlainArgsBuilder.() -> Unit):
        GetHttpNamespaceResult {
        val builder = GetHttpNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHttpNamespaceResultToKotlin(getHttpNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves information about a Service Discovery Service.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicediscovery.ServicediscoveryFunctions;
     * import com.pulumi.aws.servicediscovery.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = ServicediscoveryFunctions.getService(GetServiceArgs.builder()
     *             .name("example")
     *             .namespaceId("NAMESPACE_ID_VALUE")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param name Name of the service.
     * @param namespaceId ID of the namespace that the service belongs to.
     * @param tags Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * @param tagsAll (**Deprecated**) Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(
        name: String,
        namespaceId: String,
        tags: Map<String, String>? = null,
        tagsAll: Map<String, String>? = null,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            name = name,
            namespaceId = namespaceId,
            tags = tags,
            tagsAll = tagsAll,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicediscovery&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
