@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.GetHttpNamespacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHttpNamespace.
 * @property name Name of the http namespace.
 * @property tags Map of tags for the resource.
 */
public data class GetHttpNamespacePlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.GetHttpNamespacePlainArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.GetHttpNamespacePlainArgs =
        com.pulumi.aws.servicediscovery.inputs.GetHttpNamespacePlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetHttpNamespacePlainArgs].
 */
@PulumiTagMarker
public class GetHttpNamespacePlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the http namespace.
     */
    @JvmName("jlkdbigneijjhvqc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("mytukebramrsgpdv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("ebbrswnhjemgudjp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetHttpNamespacePlainArgs = GetHttpNamespacePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
