@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failureThreshold The number of consecutive health checks. Maximum value of 10.
 * @property resourcePath The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
 * @property type The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
 */
public data class ServiceHealthCheckConfigArgs(
    public val failureThreshold: Output<Int>? = null,
    public val resourcePath: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs =
        com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckConfigArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .resourcePath(resourcePath?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class ServiceHealthCheckConfigArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    private var resourcePath: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The number of consecutive health checks. Maximum value of 10.
     */
    @JvmName("fxidwoxxjciknrnu")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
     */
    @JvmName("rmvqyhalkryrlchr")
    public suspend fun resourcePath(`value`: Output<String>) {
        this.resourcePath = value
    }

    /**
     * @param value The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
     */
    @JvmName("cfnkqqwcoqwbiyng")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The number of consecutive health checks. Maximum value of 10.
     */
    @JvmName("vddbhblvcakeysvi")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
     */
    @JvmName("bejggkjdogwubsmd")
    public suspend fun resourcePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourcePath = mapped
    }

    /**
     * @param value The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
     */
    @JvmName("ybixbwcbddhtqols")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceHealthCheckConfigArgs = ServiceHealthCheckConfigArgs(
        failureThreshold = failureThreshold,
        resourcePath = resourcePath,
        type = type,
    )
}
