@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.inputs

import com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failureThreshold The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
 */
public data class ServiceHealthCheckCustomConfigArgs(
    public val failureThreshold: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs> {
    override fun toJava(): com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs =
        com.pulumi.aws.servicediscovery.inputs.ServiceHealthCheckCustomConfigArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceHealthCheckCustomConfigArgs].
 */
@PulumiTagMarker
public class ServiceHealthCheckCustomConfigArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    /**
     * @param value The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
     */
    @JvmName("jtwgbcdbcqniywpl")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
     */
    @JvmName("duejrukxoadnoime")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    internal fun build(): ServiceHealthCheckCustomConfigArgs = ServiceHealthCheckCustomConfigArgs(
        failureThreshold = failureThreshold,
    )
}
