@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getHttpNamespace.
 * @property arn ARN that Amazon Route 53 assigns to the namespace when you create it.
 * @property description Description that you specify for the namespace when you create it.
 * @property httpName Name of an HTTP namespace.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property tags Map of tags for the resource.
 */
public data class GetHttpNamespaceResult(
    public val arn: String,
    public val description: String,
    public val httpName: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetHttpNamespaceResult):
            GetHttpNamespaceResult = GetHttpNamespaceResult(
            arn = javaType.arn(),
            description = javaType.description(),
            httpName = javaType.httpName(),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
