@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ttl Amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
 * @property type The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
 */
public data class GetServiceDnsConfigDnsRecord(
    public val ttl: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetServiceDnsConfigDnsRecord):
            GetServiceDnsConfigDnsRecord = GetServiceDnsConfigDnsRecord(
            ttl = javaType.ttl(),
            type = javaType.type(),
        )
    }
}
