@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property failureThreshold The number of 30-second intervals that you want service discovery to wait before it changes the health status of a service instance.  Maximum value of 10.
 * @property resourcePath Path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
 * @property type The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
 */
public data class GetServiceHealthCheckConfig(
    public val failureThreshold: Int,
    public val resourcePath: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetServiceHealthCheckConfig):
            GetServiceHealthCheckConfig = GetServiceHealthCheckConfig(
            failureThreshold = javaType.failureThreshold(),
            resourcePath = javaType.resourcePath(),
            type = javaType.type(),
        )
    }
}
