@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getService.
 * @property arn ARN of the service.
 * @property description Description of the service.
 * @property dnsConfigs Complex type that contains information about the resource record sets that you want Amazon Route 53 to create when you register an instance.
 * @property healthCheckConfigs Complex type that contains settings for an optional health check. Only for Public DNS namespaces.
 * @property healthCheckCustomConfigs A complex type that contains settings for ECS managed health checks.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property namespaceId ID of the namespace to use for DNS configuration.
 * @property tags Map of tags to assign to the service. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tagsAll (**Deprecated**) Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 */
public data class GetServiceResult(
    public val arn: String,
    public val description: String,
    public val dnsConfigs: List<GetServiceDnsConfig>,
    public val healthCheckConfigs: List<GetServiceHealthCheckConfig>,
    public val healthCheckCustomConfigs: List<GetServiceHealthCheckCustomConfig>,
    public val id: String,
    public val name: String,
    public val namespaceId: String,
    public val tags: Map<String, String>? = null,
    @Deprecated(
        message = """
  this attribute has been deprecated
  """,
    )
    public val tagsAll: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.GetServiceResult):
            GetServiceResult = GetServiceResult(
            arn = javaType.arn(),
            description = javaType.description(),
            dnsConfigs = javaType.dnsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceDnsConfig.Companion.toKotlin(args0)
                })
            }),
            healthCheckConfigs = javaType.healthCheckConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceHealthCheckConfig.Companion.toKotlin(args0)
                })
            }),
            healthCheckCustomConfigs = javaType.healthCheckCustomConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.servicediscovery.kotlin.outputs.GetServiceHealthCheckCustomConfig.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            name = javaType.name(),
            namespaceId = javaType.namespaceId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tagsAll = javaType.tagsAll().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
