@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ttl The amount of time, in seconds, that you want DNS resolvers to cache the settings for this resource record set.
 * @property type The type of the resource, which indicates the value that Amazon Route 53 returns in response to DNS queries. Valid Values: A, AAAA, SRV, CNAME
 */
public data class ServiceDnsConfigDnsRecord(
    public val ttl: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.ServiceDnsConfigDnsRecord):
            ServiceDnsConfigDnsRecord = ServiceDnsConfigDnsRecord(
            ttl = javaType.ttl(),
            type = javaType.type(),
        )
    }
}
