@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicediscovery.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property failureThreshold The number of consecutive health checks. Maximum value of 10.
 * @property resourcePath The path that you want Route 53 to request when performing health checks. Route 53 automatically adds the DNS name for the service. If you don't specify a value, the default value is /.
 * @property type The type of health check that you want to create, which indicates how Route 53 determines whether an endpoint is healthy. Valid Values: HTTP, HTTPS, TCP
 */
public data class ServiceHealthCheckConfig(
    public val failureThreshold: Int? = null,
    public val resourcePath: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicediscovery.outputs.ServiceHealthCheckConfig):
            ServiceHealthCheckConfig = ServiceHealthCheckConfig(
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            resourcePath = javaType.resourcePath().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
