@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.aws.servicequotas.ServicequotasFunctions.getServicePlain
import com.pulumi.aws.servicequotas.ServicequotasFunctions.getServiceQuotaPlain
import com.pulumi.aws.servicequotas.ServicequotasFunctions.getTemplatesPlain
import com.pulumi.aws.servicequotas.kotlin.inputs.GetServicePlainArgs
import com.pulumi.aws.servicequotas.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.aws.servicequotas.kotlin.inputs.GetServiceQuotaPlainArgs
import com.pulumi.aws.servicequotas.kotlin.inputs.GetServiceQuotaPlainArgsBuilder
import com.pulumi.aws.servicequotas.kotlin.inputs.GetTemplatesPlainArgs
import com.pulumi.aws.servicequotas.kotlin.inputs.GetTemplatesPlainArgsBuilder
import com.pulumi.aws.servicequotas.kotlin.inputs.GetTemplatesTemplate
import com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceQuotaResult
import com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceResult
import com.pulumi.aws.servicequotas.kotlin.outputs.GetTemplatesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceQuotaResult.Companion.toKotlin as getServiceQuotaResultToKotlin
import com.pulumi.aws.servicequotas.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.aws.servicequotas.kotlin.outputs.GetTemplatesResult.Companion.toKotlin as getTemplatesResultToKotlin

public object ServicequotasFunctions {
    /**
     * Retrieve information about a Service Quotas Service.
     * > **NOTE:** Global quotas apply to all AWS regions, but can only be accessed in `us-east-1` in the Commercial partition or `us-gov-west-1` in the GovCloud partition. In other regions, the AWS API will return the error `The request failed because the specified service does not exist.`
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicequotas.ServicequotasFunctions;
     * import com.pulumi.aws.servicequotas.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicequotasFunctions.getService(GetServiceArgs.builder()
     *             .serviceName("Amazon Virtual Private Cloud (Amazon VPC)")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param serviceName Service name to lookup within Service Quotas. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(serviceName: String): GetServiceResult {
        val argument = GetServicePlainArgs(
            serviceName = serviceName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicequotas&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a Service Quota.
     * > **NOTE:** Global quotas apply to all AWS regions, but can only be accessed in `us-east-1` in the Commercial partition or `us-gov-west-1` in the GovCloud partition. In other regions, the AWS API will return the error `The request failed because the specified service does not exist.`
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicequotas.ServicequotasFunctions;
     * import com.pulumi.aws.servicequotas.inputs.GetServiceQuotaArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byQuotaCode = ServicequotasFunctions.getServiceQuota(GetServiceQuotaArgs.builder()
     *             .quotaCode("L-F678F1CE")
     *             .serviceCode("vpc")
     *             .build());
     *         final var byQuotaName = ServicequotasFunctions.getServiceQuota(GetServiceQuotaArgs.builder()
     *             .quotaName("VPCs per Region")
     *             .serviceCode("vpc")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getServiceQuota.
     * @return A collection of values returned by getServiceQuota.
     */
    public suspend fun getServiceQuota(argument: GetServiceQuotaPlainArgs): GetServiceQuotaResult =
        getServiceQuotaResultToKotlin(getServiceQuotaPlain(argument.toJava()).await())

    /**
     * @see [getServiceQuota].
     * @param quotaCode Quota code within the service. When configured, the data source directly looks up the service quota. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_code` or `quota_name` must be specified.
     * @param quotaName Quota name within the service. When configured, the data source searches through all service quotas to find the matching quota name. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_name` or `quota_code` must be specified.
     * @param serviceCode Service code for the quota. Available values can be found with the `aws.servicequotas.getService` data source or [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     * @return A collection of values returned by getServiceQuota.
     */
    public suspend fun getServiceQuota(
        quotaCode: String? = null,
        quotaName: String? = null,
        serviceCode: String,
    ): GetServiceQuotaResult {
        val argument = GetServiceQuotaPlainArgs(
            quotaCode = quotaCode,
            quotaName = quotaName,
            serviceCode = serviceCode,
        )
        return getServiceQuotaResultToKotlin(getServiceQuotaPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceQuota].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicequotas&#46;kotlin&#46;inputs&#46;GetServiceQuotaPlainArgs].
     * @return A collection of values returned by getServiceQuota.
     */
    public suspend fun getServiceQuota(argument: suspend GetServiceQuotaPlainArgsBuilder.() -> Unit):
        GetServiceQuotaResult {
        val builder = GetServiceQuotaPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceQuotaResultToKotlin(getServiceQuotaPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Service Quotas Templates.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.servicequotas.ServicequotasFunctions;
     * import com.pulumi.aws.servicequotas.inputs.GetTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ServicequotasFunctions.getTemplates(GetTemplatesArgs.builder()
     *             .region("us-east-1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTemplates.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: GetTemplatesPlainArgs): GetTemplatesResult =
        getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getTemplates].
     * @param region AWS Region to which the quota increases apply.
     * @param templates A list of quota increase templates for specified region. See `templates`.
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(region: String, templates: List<GetTemplatesTemplate>? = null):
        GetTemplatesResult {
        val argument = GetTemplatesPlainArgs(
            region = region,
            templates = templates,
        )
        return getTemplatesResultToKotlin(getTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;servicequotas&#46;kotlin&#46;inputs&#46;GetTemplatesPlainArgs].
     * @return A collection of values returned by getTemplates.
     */
    public suspend fun getTemplates(argument: suspend GetTemplatesPlainArgsBuilder.() -> Unit):
        GetTemplatesResult {
        val builder = GetTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTemplatesResultToKotlin(getTemplatesPlain(builtArgument.toJava()).await())
    }
}
