@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TemplateAssociation].
 */
@PulumiTagMarker
public class TemplateAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TemplateAssociationArgs = TemplateAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TemplateAssociationArgsBuilder.() -> Unit) {
        val builder = TemplateAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TemplateAssociation {
        val builtJavaResource =
            com.pulumi.aws.servicequotas.TemplateAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TemplateAssociation(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Service Quotas Template Association.
 * > Only the management account of an organization can associate Service Quota templates, and this must be done from the `us-east-1` region.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicequotas.TemplateAssociation;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TemplateAssociation("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Service Quotas Template Association using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:servicequotas/templateAssociation:TemplateAssociation example 012345678901
 * ```
 *
 */
public class TemplateAssociation internal constructor(
    override val javaResource: com.pulumi.aws.servicequotas.TemplateAssociation,
) : KotlinCustomResource(javaResource, TemplateAssociationMapper) {
    public val skipDestroy: Output<Boolean>?
        get() = javaResource.skipDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Association status. Creating this resource will result in an `ASSOCIATED` status, and quota increase requests in the template are automatically applied to new AWS accounts in the organization.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object TemplateAssociationMapper : ResourceMapper<TemplateAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.servicequotas.TemplateAssociation::class == javaResource::class

    override fun map(javaResource: Resource): TemplateAssociation = TemplateAssociation(
        javaResource
            as com.pulumi.aws.servicequotas.TemplateAssociation,
    )
}

/**
 * @see [TemplateAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TemplateAssociation].
 */
public suspend fun templateAssociation(
    name: String,
    block: suspend TemplateAssociationResourceBuilder.() -> Unit,
): TemplateAssociation {
    val builder = TemplateAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TemplateAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun templateAssociation(name: String): TemplateAssociation {
    val builder = TemplateAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
