@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin

import com.pulumi.aws.servicequotas.TemplateAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Service Quotas Template Association.
 * > Only the management account of an organization can associate Service Quota templates, and this must be done from the `us-east-1` region.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.servicequotas.TemplateAssociation;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TemplateAssociation("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Service Quotas Template Association using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:servicequotas/templateAssociation:TemplateAssociation example 012345678901
 * ```
 * @property skipDestroy
 */
public data class TemplateAssociationArgs(
    public val skipDestroy: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.TemplateAssociationArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.TemplateAssociationArgs =
        com.pulumi.aws.servicequotas.TemplateAssociationArgs.builder()
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateAssociationArgs].
 */
@PulumiTagMarker
public class TemplateAssociationArgsBuilder internal constructor() {
    private var skipDestroy: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("yfnqyjfvntooooco")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value
     */
    @JvmName("qqqjxvkatyqydlsx")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    internal fun build(): TemplateAssociationArgs = TemplateAssociationArgs(
        skipDestroy = skipDestroy,
    )
}
