@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.inputs

import com.pulumi.aws.servicequotas.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getService.
 * @property serviceName Service name to lookup within Service Quotas. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
 */
public data class GetServicePlainArgs(
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.inputs.GetServicePlainArgs =
        com.pulumi.aws.servicequotas.inputs.GetServicePlainArgs.builder()
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var serviceName: String? = null

    /**
     * @param value Service name to lookup within Service Quotas. Available values can be found with the [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     */
    @JvmName("ufhlbjrqovuiktus")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
