@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.inputs

import com.pulumi.aws.servicequotas.inputs.GetServiceQuotaPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceQuota.
 * @property quotaCode Quota code within the service. When configured, the data source directly looks up the service quota. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_code` or `quota_name` must be specified.
 * @property quotaName Quota name within the service. When configured, the data source searches through all service quotas to find the matching quota name. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_name` or `quota_code` must be specified.
 * @property serviceCode Service code for the quota. Available values can be found with the `aws.servicequotas.getService` data source or [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
 */
public data class GetServiceQuotaPlainArgs(
    public val quotaCode: String? = null,
    public val quotaName: String? = null,
    public val serviceCode: String,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.inputs.GetServiceQuotaPlainArgs> {
    override fun toJava(): com.pulumi.aws.servicequotas.inputs.GetServiceQuotaPlainArgs =
        com.pulumi.aws.servicequotas.inputs.GetServiceQuotaPlainArgs.builder()
            .quotaCode(quotaCode?.let({ args0 -> args0 }))
            .quotaName(quotaName?.let({ args0 -> args0 }))
            .serviceCode(serviceCode.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceQuotaPlainArgs].
 */
@PulumiTagMarker
public class GetServiceQuotaPlainArgsBuilder internal constructor() {
    private var quotaCode: String? = null

    private var quotaName: String? = null

    private var serviceCode: String? = null

    /**
     * @param value Quota code within the service. When configured, the data source directly looks up the service quota. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_code` or `quota_name` must be specified.
     */
    @JvmName("snlpblqkgmhbmwmc")
    public suspend fun quotaCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaCode = mapped
    }

    /**
     * @param value Quota name within the service. When configured, the data source searches through all service quotas to find the matching quota name. Available values can be found with the [AWS CLI service-quotas list-service-quotas command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html). One of `quota_name` or `quota_code` must be specified.
     */
    @JvmName("uvedkibxnnrmcjac")
    public suspend fun quotaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.quotaName = mapped
    }

    /**
     * @param value Service code for the quota. Available values can be found with the `aws.servicequotas.getService` data source or [AWS CLI service-quotas list-services command](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-services.html).
     */
    @JvmName("vqjvjjctnxtsumfg")
    public suspend fun serviceCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceCode = mapped
    }

    internal fun build(): GetServiceQuotaPlainArgs = GetServiceQuotaPlainArgs(
        quotaCode = quotaCode,
        quotaName = quotaName,
        serviceCode = serviceCode ?: throw PulumiNullFieldException("serviceCode"),
    )
}
