@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.inputs

import com.pulumi.aws.servicequotas.inputs.GetTemplatesTemplate.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property globalQuota Indicates whether the quota is global.
 * @property quotaCode Quota identifier.
 * @property quotaName Quota name.
 * @property region AWS Region to which the quota increases apply.
 * @property serviceCode (Required) Service identifier.
 * @property serviceName Service name.
 * @property unit Unit of measurement.
 * @property value (Required) The new, increased value for the quota.
 */
public data class GetTemplatesTemplate(
    public val globalQuota: Boolean,
    public val quotaCode: String,
    public val quotaName: String,
    public val region: String,
    public val serviceCode: String,
    public val serviceName: String,
    public val unit: String,
    public val `value`: Double,
) : ConvertibleToJava<com.pulumi.aws.servicequotas.inputs.GetTemplatesTemplate> {
    override fun toJava(): com.pulumi.aws.servicequotas.inputs.GetTemplatesTemplate =
        com.pulumi.aws.servicequotas.inputs.GetTemplatesTemplate.builder()
            .globalQuota(globalQuota.let({ args0 -> args0 }))
            .quotaCode(quotaCode.let({ args0 -> args0 }))
            .quotaName(quotaName.let({ args0 -> args0 }))
            .region(region.let({ args0 -> args0 }))
            .serviceCode(serviceCode.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .unit(unit.let({ args0 -> args0 }))
            .`value`(`value`.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTemplatesTemplate].
 */
@PulumiTagMarker
public class GetTemplatesTemplateBuilder internal constructor() {
    private var globalQuota: Boolean? = null

    private var quotaCode: String? = null

    private var quotaName: String? = null

    private var region: String? = null

    private var serviceCode: String? = null

    private var serviceName: String? = null

    private var unit: String? = null

    private var `value`: Double? = null

    /**
     * @param value Indicates whether the quota is global.
     */
    @JvmName("leherysagigwvhxg")
    public suspend fun globalQuota(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalQuota = mapped
    }

    /**
     * @param value Quota identifier.
     */
    @JvmName("fsejssqnojrfjgpd")
    public suspend fun quotaCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.quotaCode = mapped
    }

    /**
     * @param value Quota name.
     */
    @JvmName("ohqndapqoelnpffq")
    public suspend fun quotaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.quotaName = mapped
    }

    /**
     * @param value AWS Region to which the quota increases apply.
     */
    @JvmName("ngytbbglbtmfjtqc")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value (Required) Service identifier.
     */
    @JvmName("txlosidrareljibx")
    public suspend fun serviceCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceCode = mapped
    }

    /**
     * @param value Service name.
     */
    @JvmName("fhsuskkgfrsnapyh")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value Unit of measurement.
     */
    @JvmName("veqiyccspcikndib")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.unit = mapped
    }

    /**
     * @param value (Required) The new, increased value for the quota.
     */
    @JvmName("sprrphewkaglsmse")
    public suspend fun `value`(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.`value` = mapped
    }

    internal fun build(): GetTemplatesTemplate = GetTemplatesTemplate(
        globalQuota = globalQuota ?: throw PulumiNullFieldException("globalQuota"),
        quotaCode = quotaCode ?: throw PulumiNullFieldException("quotaCode"),
        quotaName = quotaName ?: throw PulumiNullFieldException("quotaName"),
        region = region ?: throw PulumiNullFieldException("region"),
        serviceCode = serviceCode ?: throw PulumiNullFieldException("serviceCode"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        unit = unit ?: throw PulumiNullFieldException("unit"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
