@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.servicequotas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getService.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property serviceCode Code of the service.
 * @property serviceName
 */
public data class GetServiceResult(
    public val id: String,
    public val serviceCode: String,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.servicequotas.outputs.GetServiceResult):
            GetServiceResult = GetServiceResult(
            id = javaType.id(),
            serviceCode = javaType.serviceCode(),
            serviceName = javaType.serviceName(),
        )
    }
}
