@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ActiveReceiptRuleSet].
 */
@PulumiTagMarker
public class ActiveReceiptRuleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ActiveReceiptRuleSetArgs = ActiveReceiptRuleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ActiveReceiptRuleSetArgsBuilder.() -> Unit) {
        val builder = ActiveReceiptRuleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ActiveReceiptRuleSet {
        val builtJavaResource = com.pulumi.aws.ses.ActiveReceiptRuleSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ActiveReceiptRuleSet(builtJavaResource)
    }
}

/**
 * Provides a resource to designate the active SES receipt rule set
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ActiveReceiptRuleSet;
 * import com.pulumi.aws.ses.ActiveReceiptRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new ActiveReceiptRuleSet("main", ActiveReceiptRuleSetArgs.builder()
 *             .ruleSetName("primary-rules")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import active SES receipt rule sets using the rule set name. For example:
 * ```sh
 *  $ pulumi import aws:ses/activeReceiptRuleSet:ActiveReceiptRuleSet my_rule_set my_rule_set_name
 * ```
 *
 */
public class ActiveReceiptRuleSet internal constructor(
    override val javaResource: com.pulumi.aws.ses.ActiveReceiptRuleSet,
) : KotlinCustomResource(javaResource, ActiveReceiptRuleSetMapper) {
    /**
     * The SES receipt rule set ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the rule set
     */
    public val ruleSetName: Output<String>
        get() = javaResource.ruleSetName().applyValue({ args0 -> args0 })
}

public object ActiveReceiptRuleSetMapper : ResourceMapper<ActiveReceiptRuleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.ActiveReceiptRuleSet::class == javaResource::class

    override fun map(javaResource: Resource): ActiveReceiptRuleSet = ActiveReceiptRuleSet(
        javaResource
            as com.pulumi.aws.ses.ActiveReceiptRuleSet,
    )
}

/**
 * @see [ActiveReceiptRuleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ActiveReceiptRuleSet].
 */
public suspend fun activeReceiptRuleSet(
    name: String,
    block: suspend ActiveReceiptRuleSetResourceBuilder.() -> Unit,
): ActiveReceiptRuleSet {
    val builder = ActiveReceiptRuleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ActiveReceiptRuleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun activeReceiptRuleSet(name: String): ActiveReceiptRuleSet {
    val builder = ActiveReceiptRuleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
