@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.ActiveReceiptRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to designate the active SES receipt rule set
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ActiveReceiptRuleSet;
 * import com.pulumi.aws.ses.ActiveReceiptRuleSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new ActiveReceiptRuleSet("main", ActiveReceiptRuleSetArgs.builder()
 *             .ruleSetName("primary-rules")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import active SES receipt rule sets using the rule set name. For example:
 * ```sh
 *  $ pulumi import aws:ses/activeReceiptRuleSet:ActiveReceiptRuleSet my_rule_set my_rule_set_name
 * ```
 * @property ruleSetName The name of the rule set
 */
public data class ActiveReceiptRuleSetArgs(
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.ActiveReceiptRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.ses.ActiveReceiptRuleSetArgs =
        com.pulumi.aws.ses.ActiveReceiptRuleSetArgs.builder()
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveReceiptRuleSetArgs].
 */
@PulumiTagMarker
public class ActiveReceiptRuleSetArgsBuilder internal constructor() {
    private var ruleSetName: Output<String>? = null

    /**
     * @param value The name of the rule set
     */
    @JvmName("toeqwvivyvcsmwth")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value The name of the rule set
     */
    @JvmName("fpfdkwdqcoybugwr")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): ActiveReceiptRuleSetArgs = ActiveReceiptRuleSetArgs(
        ruleSetName = ruleSetName,
    )
}
