@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.kotlin.outputs.ConfigurationSetDeliveryOptions
import com.pulumi.aws.ses.kotlin.outputs.ConfigurationSetTrackingOptions
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.ses.kotlin.outputs.ConfigurationSetDeliveryOptions.Companion.toKotlin as configurationSetDeliveryOptionsToKotlin
import com.pulumi.aws.ses.kotlin.outputs.ConfigurationSetTrackingOptions.Companion.toKotlin as configurationSetTrackingOptionsToKotlin

/**
 * Builder for [ConfigurationSet].
 */
@PulumiTagMarker
public class ConfigurationSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationSetArgs = ConfigurationSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationSetArgsBuilder.() -> Unit) {
        val builder = ConfigurationSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConfigurationSet {
        val builtJavaResource = com.pulumi.aws.ses.ConfigurationSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConfigurationSet(builtJavaResource)
    }
}

/**
 * Provides an SES configuration set resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ConfigurationSet;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ConfigurationSet("test");
 *     }
 * }
 * ```
 * ### Require TLS Connections
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.ConfigurationSet;
 * import com.pulumi.aws.ses.ConfigurationSetArgs;
 * import com.pulumi.aws.ses.inputs.ConfigurationSetDeliveryOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ConfigurationSet("test", ConfigurationSetArgs.builder()
 *             .deliveryOptions(ConfigurationSetDeliveryOptionsArgs.builder()
 *                 .tlsPolicy("Require")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES Configuration Sets using their `name`. For example:
 * ```sh
 *  $ pulumi import aws:ses/configurationSet:ConfigurationSet test some-configuration-set-test
 * ```
 *
 */
public class ConfigurationSet internal constructor(
    override val javaResource: com.pulumi.aws.ses.ConfigurationSet,
) : KotlinCustomResource(javaResource, ConfigurationSetMapper) {
    /**
     * SES configuration set ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether messages that use the configuration set are required to use TLS. See below.
     */
    public val deliveryOptions: Output<ConfigurationSetDeliveryOptions>?
        get() = javaResource.deliveryOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationSetDeliveryOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Date and time at which the reputation metrics for the configuration set were last reset. Resetting these metrics is known as a fresh start.
     */
    public val lastFreshStart: Output<String>
        get() = javaResource.lastFreshStart().applyValue({ args0 -> args0 })

    /**
     * Name of the configuration set.
     * The following argument is optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether or not Amazon SES publishes reputation metrics for the configuration set, such as bounce and complaint rates, to Amazon CloudWatch. The default value is `false`.
     */
    public val reputationMetricsEnabled: Output<Boolean>?
        get() = javaResource.reputationMetricsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether email sending is enabled or disabled for the configuration set. The default value is `true`.
     */
    public val sendingEnabled: Output<Boolean>?
        get() = javaResource.sendingEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain that is used to redirect email recipients to an Amazon SES-operated domain. See below. **NOTE:** This functionality is best effort.
     */
    public val trackingOptions: Output<ConfigurationSetTrackingOptions>?
        get() = javaResource.trackingOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configurationSetTrackingOptionsToKotlin(args0) })
            }).orElse(null)
        })
}

public object ConfigurationSetMapper : ResourceMapper<ConfigurationSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.ConfigurationSet::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationSet = ConfigurationSet(
        javaResource as
            com.pulumi.aws.ses.ConfigurationSet,
    )
}

/**
 * @see [ConfigurationSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationSet].
 */
public suspend fun configurationSet(
    name: String,
    block: suspend ConfigurationSetResourceBuilder.() -> Unit,
): ConfigurationSet {
    val builder = ConfigurationSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationSet(name: String): ConfigurationSet {
    val builder = ConfigurationSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
