@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainDkim].
 */
@PulumiTagMarker
public class DomainDkimResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainDkimArgs = DomainDkimArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainDkimArgsBuilder.() -> Unit) {
        val builder = DomainDkimArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainDkim {
        val builtJavaResource = com.pulumi.aws.ses.DomainDkim(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainDkim(builtJavaResource)
    }
}

/**
 * Provides an SES domain DKIM generation resource.
 * Domain ownership needs to be confirmed first using ses_domain_identity Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.ses.DomainDkim;
 * import com.pulumi.aws.ses.DomainDkimArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleDomainDkim = new DomainDkim("exampleDomainDkim", DomainDkimArgs.builder()
 *             .domain(exampleDomainIdentity.domain())
 *             .build());
 *         for (var i = 0; i < 3; i++) {
 *             new Record("exampleAmazonsesDkimRecord-" + i, RecordArgs.builder()
 *                 .zoneId("ABCDEFGHIJ123")
 *                 .name(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s._domainkey", dkimTokens[range.value()])))
 *                 .type("CNAME")
 *                 .ttl("600")
 *                 .records(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s.dkim.amazonses.com", dkimTokens[range.value()])))
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DKIM tokens using the `domain` attribute. For example:
 * ```sh
 *  $ pulumi import aws:ses/domainDkim:DomainDkim example example.com
 * ```
 *
 */
public class DomainDkim internal constructor(
    override val javaResource: com.pulumi.aws.ses.DomainDkim,
) : KotlinCustomResource(javaResource, DomainDkimMapper) {
    /**
     * DKIM tokens generated by SES.
     * These tokens should be used to create CNAME records used to verify SES Easy DKIM.
     * See below for an example of how this might be achieved
     * when the domain is hosted in Route 53 and managed by this provider.
     * Find out more about verifying domains in Amazon SES
     * in the [AWS SES docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
     */
    public val dkimTokens: Output<List<String>>
        get() = javaResource.dkimTokens().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Verified domain name to generate DKIM tokens for.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })
}

public object DomainDkimMapper : ResourceMapper<DomainDkim> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.DomainDkim::class == javaResource::class

    override fun map(javaResource: Resource): DomainDkim = DomainDkim(
        javaResource as
            com.pulumi.aws.ses.DomainDkim,
    )
}

/**
 * @see [DomainDkim].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainDkim].
 */
public suspend fun domainDkim(name: String, block: suspend DomainDkimResourceBuilder.() -> Unit):
    DomainDkim {
    val builder = DomainDkimResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainDkim].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainDkim(name: String): DomainDkim {
    val builder = DomainDkimResourceBuilder()
    builder.name(name)
    return builder.build()
}
