@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.DomainDkimArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES domain DKIM generation resource.
 * Domain ownership needs to be confirmed first using ses_domain_identity Resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.ses.DomainDkim;
 * import com.pulumi.aws.ses.DomainDkimArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.codegen.internal.KeyedValue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleDomainIdentity = new DomainIdentity("exampleDomainIdentity", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleDomainDkim = new DomainDkim("exampleDomainDkim", DomainDkimArgs.builder()
 *             .domain(exampleDomainIdentity.domain())
 *             .build());
 *         for (var i = 0; i < 3; i++) {
 *             new Record("exampleAmazonsesDkimRecord-" + i, RecordArgs.builder()
 *                 .zoneId("ABCDEFGHIJ123")
 *                 .name(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s._domainkey", dkimTokens[range.value()])))
 *                 .type("CNAME")
 *                 .ttl("600")
 *                 .records(exampleDomainDkim.dkimTokens().applyValue(dkimTokens -> String.format("%s.dkim.amazonses.com", dkimTokens[range.value()])))
 *                 .build());
 * }
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import DKIM tokens using the `domain` attribute. For example:
 * ```sh
 *  $ pulumi import aws:ses/domainDkim:DomainDkim example example.com
 * ```
 * @property domain Verified domain name to generate DKIM tokens for.
 */
public data class DomainDkimArgs(
    public val domain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.DomainDkimArgs> {
    override fun toJava(): com.pulumi.aws.ses.DomainDkimArgs =
        com.pulumi.aws.ses.DomainDkimArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDkimArgs].
 */
@PulumiTagMarker
public class DomainDkimArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    /**
     * @param value Verified domain name to generate DKIM tokens for.
     */
    @JvmName("haranifkhpnwfaig")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value Verified domain name to generate DKIM tokens for.
     */
    @JvmName("phxylwfwjfhduvpw")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): DomainDkimArgs = DomainDkimArgs(
        domain = domain,
    )
}
