@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainIdentity].
 */
@PulumiTagMarker
public class DomainIdentityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainIdentityArgs = DomainIdentityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainIdentityArgsBuilder.() -> Unit) {
        val builder = DomainIdentityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainIdentity {
        val builtJavaResource = com.pulumi.aws.ses.DomainIdentity(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainIdentity(builtJavaResource)
    }
}

/**
 * Provides an SES domain identity resource
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### With Route53 Record
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleAmazonsesVerificationRecord = new Record("exampleAmazonsesVerificationRecord", RecordArgs.builder()
 *             .zoneId("ABCDEFGHIJ123")
 *             .name("_amazonses.example.com")
 *             .type("TXT")
 *             .ttl("600")
 *             .records(example.verificationToken())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES domain identities using the domain name. For example:
 * ```sh
 *  $ pulumi import aws:ses/domainIdentity:DomainIdentity example example.com
 * ```
 *
 */
public class DomainIdentity internal constructor(
    override val javaResource: com.pulumi.aws.ses.DomainIdentity,
) : KotlinCustomResource(javaResource, DomainIdentityMapper) {
    /**
     * The ARN of the domain identity.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The domain name to assign to SES
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * A code which when added to the domain as a TXT record
     * will signal to SES that the owner of the domain has authorised SES to act on
     * their behalf. The domain identity will be in state "verification pending"
     * until this is done. See the With Route53 Record example
     * for how this might be achieved when the domain is hosted in Route 53 and
     * managed by this provider.  Find out more about verifying domains in Amazon
     * SES in the [AWS SES
   * docs](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html).
     */
    public val verificationToken: Output<String>
        get() = javaResource.verificationToken().applyValue({ args0 -> args0 })
}

public object DomainIdentityMapper : ResourceMapper<DomainIdentity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.DomainIdentity::class == javaResource::class

    override fun map(javaResource: Resource): DomainIdentity = DomainIdentity(
        javaResource as
            com.pulumi.aws.ses.DomainIdentity,
    )
}

/**
 * @see [DomainIdentity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainIdentity].
 */
public suspend fun domainIdentity(
    name: String,
    block: suspend DomainIdentityResourceBuilder.() -> Unit,
): DomainIdentity {
    val builder = DomainIdentityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainIdentity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainIdentity(name: String): DomainIdentity {
    val builder = DomainIdentityResourceBuilder()
    builder.name(name)
    return builder.build()
}
