@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.DomainIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES domain identity resource
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *     }
 * }
 * ```
 * ### With Route53 Record
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleAmazonsesVerificationRecord = new Record("exampleAmazonsesVerificationRecord", RecordArgs.builder()
 *             .zoneId("ABCDEFGHIJ123")
 *             .name("_amazonses.example.com")
 *             .type("TXT")
 *             .ttl("600")
 *             .records(example.verificationToken())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES domain identities using the domain name. For example:
 * ```sh
 *  $ pulumi import aws:ses/domainIdentity:DomainIdentity example example.com
 * ```
 * @property domain The domain name to assign to SES
 */
public data class DomainIdentityArgs(
    public val domain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.DomainIdentityArgs> {
    override fun toJava(): com.pulumi.aws.ses.DomainIdentityArgs =
        com.pulumi.aws.ses.DomainIdentityArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainIdentityArgs].
 */
@PulumiTagMarker
public class DomainIdentityArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    /**
     * @param value The domain name to assign to SES
     */
    @JvmName("kpkswyvsyrdlbsey")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The domain name to assign to SES
     */
    @JvmName("jbwvkkogkxekmnno")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): DomainIdentityArgs = DomainIdentityArgs(
        domain = domain,
    )
}
