@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainIdentityVerification].
 */
@PulumiTagMarker
public class DomainIdentityVerificationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainIdentityVerificationArgs = DomainIdentityVerificationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainIdentityVerificationArgsBuilder.() -> Unit) {
        val builder = DomainIdentityVerificationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DomainIdentityVerification {
        val builtJavaResource = com.pulumi.aws.ses.DomainIdentityVerification(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainIdentityVerification(builtJavaResource)
    }
}

/**
 * Represents a successful verification of an SES domain identity.
 * Most commonly, this resource is used together with `aws.route53.Record` and
 * `aws.ses.DomainIdentity` to request an SES domain identity,
 * deploy the required DNS verification records, and wait for verification to complete.
 * > **WARNING:** This resource implements a part of the verification workflow. It does not represent a real-world entity in AWS, therefore changing or deleting this resource on its own has no immediate effect.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.ses.DomainIdentityVerification;
 * import com.pulumi.aws.ses.DomainIdentityVerificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleAmazonsesVerificationRecord = new Record("exampleAmazonsesVerificationRecord", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().zone_id())
 *             .name(example.id().applyValue(id -> String.format("_amazonses.%s", id)))
 *             .type("TXT")
 *             .ttl("600")
 *             .records(example.verificationToken())
 *             .build());
 *         var exampleVerification = new DomainIdentityVerification("exampleVerification", DomainIdentityVerificationArgs.builder()
 *             .domain(example.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAmazonsesVerificationRecord)
 *                 .build());
 *     }
 * }
 * ```
 */
public class DomainIdentityVerification internal constructor(
    override val javaResource: com.pulumi.aws.ses.DomainIdentityVerification,
) : KotlinCustomResource(javaResource, DomainIdentityVerificationMapper) {
    /**
     * The ARN of the domain identity.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The domain name of the SES domain identity to verify.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })
}

public object DomainIdentityVerificationMapper : ResourceMapper<DomainIdentityVerification> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.DomainIdentityVerification::class == javaResource::class

    override fun map(javaResource: Resource): DomainIdentityVerification =
        DomainIdentityVerification(javaResource as com.pulumi.aws.ses.DomainIdentityVerification)
}

/**
 * @see [DomainIdentityVerification].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainIdentityVerification].
 */
public suspend fun domainIdentityVerification(
    name: String,
    block: suspend DomainIdentityVerificationResourceBuilder.() -> Unit,
):
    DomainIdentityVerification {
    val builder = DomainIdentityVerificationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainIdentityVerification].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainIdentityVerification(name: String): DomainIdentityVerification {
    val builder = DomainIdentityVerificationResourceBuilder()
    builder.name(name)
    return builder.build()
}
