@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.DomainIdentityVerificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a successful verification of an SES domain identity.
 * Most commonly, this resource is used together with `aws.route53.Record` and
 * `aws.ses.DomainIdentity` to request an SES domain identity,
 * deploy the required DNS verification records, and wait for verification to complete.
 * > **WARNING:** This resource implements a part of the verification workflow. It does not represent a real-world entity in AWS, therefore changing or deleting this resource on its own has no immediate effect.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.DomainIdentity;
 * import com.pulumi.aws.ses.DomainIdentityArgs;
 * import com.pulumi.aws.route53.Record;
 * import com.pulumi.aws.route53.RecordArgs;
 * import com.pulumi.aws.ses.DomainIdentityVerification;
 * import com.pulumi.aws.ses.DomainIdentityVerificationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DomainIdentity("example", DomainIdentityArgs.builder()
 *             .domain("example.com")
 *             .build());
 *         var exampleAmazonsesVerificationRecord = new Record("exampleAmazonsesVerificationRecord", RecordArgs.builder()
 *             .zoneId(aws_route53_zone.example().zone_id())
 *             .name(example.id().applyValue(id -> String.format("_amazonses.%s", id)))
 *             .type("TXT")
 *             .ttl("600")
 *             .records(example.verificationToken())
 *             .build());
 *         var exampleVerification = new DomainIdentityVerification("exampleVerification", DomainIdentityVerificationArgs.builder()
 *             .domain(example.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAmazonsesVerificationRecord)
 *                 .build());
 *     }
 * }
 * ```
 * @property domain The domain name of the SES domain identity to verify.
 */
public data class DomainIdentityVerificationArgs(
    public val domain: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.DomainIdentityVerificationArgs> {
    override fun toJava(): com.pulumi.aws.ses.DomainIdentityVerificationArgs =
        com.pulumi.aws.ses.DomainIdentityVerificationArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainIdentityVerificationArgs].
 */
@PulumiTagMarker
public class DomainIdentityVerificationArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    /**
     * @param value The domain name of the SES domain identity to verify.
     */
    @JvmName("gowtmmrkguklosqo")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The domain name of the SES domain identity to verify.
     */
    @JvmName("tqunvjxlvpwwtbmc")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    internal fun build(): DomainIdentityVerificationArgs = DomainIdentityVerificationArgs(
        domain = domain,
    )
}
