@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EmailIdentity].
 */
@PulumiTagMarker
public class EmailIdentityResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EmailIdentityArgs = EmailIdentityArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EmailIdentityArgsBuilder.() -> Unit) {
        val builder = EmailIdentityArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EmailIdentity {
        val builtJavaResource = com.pulumi.aws.ses.EmailIdentity(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EmailIdentity(builtJavaResource)
    }
}

/**
 * Provides an SES email identity resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EmailIdentity;
 * import com.pulumi.aws.ses.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .email("email@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES email identities using the email address. For example:
 * ```sh
 *  $ pulumi import aws:ses/emailIdentity:EmailIdentity example email@example.com
 * ```
 *
 */
public class EmailIdentity internal constructor(
    override val javaResource: com.pulumi.aws.ses.EmailIdentity,
) : KotlinCustomResource(javaResource, EmailIdentityMapper) {
    /**
     * The ARN of the email identity.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The email address to assign to SES.
     */
    public val email: Output<String>
        get() = javaResource.email().applyValue({ args0 -> args0 })
}

public object EmailIdentityMapper : ResourceMapper<EmailIdentity> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.EmailIdentity::class == javaResource::class

    override fun map(javaResource: Resource): EmailIdentity = EmailIdentity(
        javaResource as
            com.pulumi.aws.ses.EmailIdentity,
    )
}

/**
 * @see [EmailIdentity].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EmailIdentity].
 */
public suspend fun emailIdentity(
    name: String,
    block: suspend EmailIdentityResourceBuilder.() -> Unit,
): EmailIdentity {
    val builder = EmailIdentityResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EmailIdentity].
 * @param name The _unique_ name of the resulting resource.
 */
public fun emailIdentity(name: String): EmailIdentity {
    val builder = EmailIdentityResourceBuilder()
    builder.name(name)
    return builder.build()
}
