@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.EmailIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an SES email identity resource
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EmailIdentity;
 * import com.pulumi.aws.ses.EmailIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EmailIdentity("example", EmailIdentityArgs.builder()
 *             .email("email@example.com")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES email identities using the email address. For example:
 * ```sh
 *  $ pulumi import aws:ses/emailIdentity:EmailIdentity example email@example.com
 * ```
 * @property email The email address to assign to SES.
 */
public data class EmailIdentityArgs(
    public val email: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ses.EmailIdentityArgs> {
    override fun toJava(): com.pulumi.aws.ses.EmailIdentityArgs =
        com.pulumi.aws.ses.EmailIdentityArgs.builder()
            .email(email?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EmailIdentityArgs].
 */
@PulumiTagMarker
public class EmailIdentityArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    /**
     * @param value The email address to assign to SES.
     */
    @JvmName("camftdluhnkmikty")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value The email address to assign to SES.
     */
    @JvmName("mlwgysnviscsisas")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    internal fun build(): EmailIdentityArgs = EmailIdentityArgs(
        email = email,
    )
}
