@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ses.kotlin

import com.pulumi.aws.ses.kotlin.outputs.EventDestinationCloudwatchDestination
import com.pulumi.aws.ses.kotlin.outputs.EventDestinationKinesisDestination
import com.pulumi.aws.ses.kotlin.outputs.EventDestinationSnsDestination
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.ses.kotlin.outputs.EventDestinationCloudwatchDestination.Companion.toKotlin as eventDestinationCloudwatchDestinationToKotlin
import com.pulumi.aws.ses.kotlin.outputs.EventDestinationKinesisDestination.Companion.toKotlin as eventDestinationKinesisDestinationToKotlin
import com.pulumi.aws.ses.kotlin.outputs.EventDestinationSnsDestination.Companion.toKotlin as eventDestinationSnsDestinationToKotlin

/**
 * Builder for [EventDestination].
 */
@PulumiTagMarker
public class EventDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventDestinationArgs = EventDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventDestinationArgsBuilder.() -> Unit) {
        val builder = EventDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EventDestination {
        val builtJavaResource = com.pulumi.aws.ses.EventDestination(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventDestination(builtJavaResource)
    }
}

/**
 * Provides an SES event destination
 * ## Example Usage
 * ### CloudWatch Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationCloudwatchDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudwatch = new EventDestination("cloudwatch", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .cloudwatchDestinations(EventDestinationCloudwatchDestinationArgs.builder()
 *                 .defaultValue("default")
 *                 .dimensionName("dimension")
 *                 .valueSource("emailHeader")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Kinesis Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationKinesisDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kinesis = new EventDestination("kinesis", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .kinesisDestination(EventDestinationKinesisDestinationArgs.builder()
 *                 .streamArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### SNS Destination
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ses.EventDestination;
 * import com.pulumi.aws.ses.EventDestinationArgs;
 * import com.pulumi.aws.ses.inputs.EventDestinationSnsDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sns = new EventDestination("sns", EventDestinationArgs.builder()
 *             .configurationSetName(aws_ses_configuration_set.example().name())
 *             .enabled(true)
 *             .matchingTypes(
 *                 "bounce",
 *                 "send")
 *             .snsDestination(EventDestinationSnsDestinationArgs.builder()
 *                 .topicArn(aws_sns_topic.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import SES event destinations using `configuration_set_name` together with the event destination's `name`. For example:
 * ```sh
 *  $ pulumi import aws:ses/eventDestination:EventDestination sns some-configuration-set-test/event-destination-sns
 * ```
 *
 */
public class EventDestination internal constructor(
    override val javaResource: com.pulumi.aws.ses.EventDestination,
) : KotlinCustomResource(javaResource, EventDestinationMapper) {
    /**
     * The SES event destination ARN.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * CloudWatch destination for the events
     */
    public val cloudwatchDestinations: Output<List<EventDestinationCloudwatchDestination>>?
        get() = javaResource.cloudwatchDestinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        eventDestinationCloudwatchDestinationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name of the configuration set
     */
    public val configurationSetName: Output<String>
        get() = javaResource.configurationSetName().applyValue({ args0 -> args0 })

    /**
     * If true, the event destination will be enabled
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Send the events to a kinesis firehose destination
     */
    public val kinesisDestination: Output<EventDestinationKinesisDestination>?
        get() = javaResource.kinesisDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventDestinationKinesisDestinationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * A list of matching types. May be any of `"send"`, `"reject"`, `"bounce"`, `"complaint"`, `"delivery"`, `"open"`, `"click"`, or `"renderingFailure"`.
     */
    public val matchingTypes: Output<List<String>>
        get() = javaResource.matchingTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the event destination
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Send the events to an SNS Topic destination
     * > **NOTE:** You can specify `"cloudwatch_destination"` or `"kinesis_destination"` but not both
     */
    public val snsDestination: Output<EventDestinationSnsDestination>?
        get() = javaResource.snsDestination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> eventDestinationSnsDestinationToKotlin(args0) })
            }).orElse(null)
        })
}

public object EventDestinationMapper : ResourceMapper<EventDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ses.EventDestination::class == javaResource::class

    override fun map(javaResource: Resource): EventDestination = EventDestination(
        javaResource as
            com.pulumi.aws.ses.EventDestination,
    )
}

/**
 * @see [EventDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventDestination].
 */
public suspend fun eventDestination(
    name: String,
    block: suspend EventDestinationResourceBuilder.() -> Unit,
): EventDestination {
    val builder = EventDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventDestination(name: String): EventDestination {
    val builder = EventDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
